/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.continuous;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.LongUnaryOperator;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.SystemProperty;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryEntry;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.jetbrains.annotations.Nullable;

public class CacheContinuousQueryEventBuffer {
    public static final int DFLT_CONTINUOUS_QUERY_PENDING_BUFF_SIZE = 10000;
    public static final int DFLT_CONTINUOUS_QUERY_SERVER_BUFFER_SIZE = 1000;
    @SystemProperty(value="The max size of the buffer with pending continuous queries events", type=Long.class, defaults="10000")
    public static final String IGNITE_CONTINUOUS_QUERY_PENDING_BUFF_SIZE = "IGNITE_CONTINUOUS_QUERY_PENDING_BUFF_SIZE";
    @SystemProperty(value="Continuous queries batch buffer size", type=Long.class, defaults="1000")
    public static final String IGNITE_CONTINUOUS_QUERY_SERVER_BUFFER_SIZE = "IGNITE_CONTINUOUS_QUERY_SERVER_BUFFER_SIZE";
    public static final int MAX_PENDING_BUFF_SIZE = IgniteSystemProperties.getInteger("IGNITE_CONTINUOUS_QUERY_PENDING_BUFF_SIZE", 10000);
    private static final int BUF_SIZE = IgniteSystemProperties.getInteger("IGNITE_CONTINUOUS_QUERY_SERVER_BUFFER_SIZE", 1000);
    private static final Object RETRY = new Object();
    private final IgniteLogger log;
    private final LongUnaryOperator currPartCntr;
    private final AtomicReference<Batch> curBatch = new AtomicReference();
    private final Deque<CacheContinuousQueryEntry> backupQ = new ConcurrentLinkedDeque<CacheContinuousQueryEntry>();
    private final ConcurrentSkipListMap<Long, CacheContinuousQueryEntry> pending = new ConcurrentSkipListMap();
    private final AtomicInteger pendingCurrSize = new AtomicInteger();
    private final GridAtomicLong ackedUpdCntr = new GridAtomicLong(0L);

    CacheContinuousQueryEventBuffer(LongUnaryOperator currPartCntr, IgniteLogger log) {
        this.currPartCntr = currPartCntr;
        this.log = log;
    }

    CacheContinuousQueryEventBuffer(IgniteLogger log) {
        this(backup -> 0L, log);
    }

    void cleanupOnAck(long updateCntr) {
        this.backupQ.removeIf(backupEntry -> backupEntry.updateCounter() <= updateCntr);
        this.ackedUpdCntr.setIfGreater(updateCntr);
    }

    @Nullable
    Collection<CacheContinuousQueryEntry> flushOnExchange(BiFunction<Long, Long, CacheContinuousQueryEntry> filteredFactory) {
        CacheContinuousQueryEntry e;
        TreeMap<Long, CacheContinuousQueryEntry> ret = new TreeMap<Long, CacheContinuousQueryEntry>();
        int size = this.backupQ.size();
        for (int i = 0; i < size && (e = this.backupQ.pollFirst()) != null; ++i) {
            ret.put(e.updateCounter(), e);
        }
        Batch batch = this.curBatch.get();
        if (batch != null) {
            ret.putAll(batch.flushCurrentEntries(filteredFactory));
        }
        for (CacheContinuousQueryEntry e2 : this.pending.values()) {
            ret.put(e2.updateCounter(), e2);
        }
        return ret.isEmpty() ? null : ret.values();
    }

    long currentFiltered() {
        Batch batch = this.curBatch.get();
        return batch != null ? batch.filtered : 0L;
    }

    @Nullable
    Object processEntry(CacheContinuousQueryEntry e, boolean backup) {
        return this.process0(e.updateCounter(), e, backup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object process0(long cntr, CacheContinuousQueryEntry entry, boolean backup) {
        Batch batch;
        Object res;
        block15: {
            assert (cntr >= 0L) : cntr;
            res = null;
            while (true) {
                if ((batch = this.initBatch(backup)) == null || cntr < batch.startCntr) {
                    if (backup && cntr > this.ackedUpdCntr.get()) {
                        this.backupQ.add(entry);
                    }
                    return backup ? null : entry;
                }
                if (cntr <= batch.endCntr) {
                    res = batch.processEntry0(null, cntr, entry, backup);
                    if (res == RETRY) {
                        continue;
                    }
                    break block15;
                }
                if (batch.endCntr >= this.ackedUpdCntr.get() || batch.tryRollOver() != RETRY) break;
            }
            this.pendingCurrSize.incrementAndGet();
            this.pending.put(cntr, entry);
            if (this.pendingCurrSize.get() > MAX_PENDING_BUFF_SIZE) {
                ConcurrentSkipListMap<Long, CacheContinuousQueryEntry> concurrentSkipListMap = this.pending;
                synchronized (concurrentSkipListMap) {
                    if (this.pendingCurrSize.get() <= MAX_PENDING_BUFF_SIZE) {
                    } else {
                        LT.warn(this.log, "Buffer for pending events reached max of its size [cacheId=" + entry.cacheId() + ", maxSize=" + MAX_PENDING_BUFF_SIZE + ", partId=" + entry.partition() + ']');
                        Iterator<Map.Entry<Long, CacheContinuousQueryEntry>> iter = this.pending.entrySet().iterator();
                        for (int keysToRemove = BUF_SIZE; iter.hasNext() && keysToRemove > 0; --keysToRemove) {
                            CacheContinuousQueryEntry entry0 = iter.next().getValue();
                            if (!backup) {
                                res = this.addResult(res, entry0.copyWithDataReset(), backup);
                            }
                            iter.remove();
                            this.pendingCurrSize.decrementAndGet();
                        }
                    }
                }
            }
        }
        Batch batch0 = this.curBatch.get();
        while (batch != batch0) {
            batch = batch0;
            res = this.processPending(res, batch, backup);
            batch0 = this.curBatch.get();
        }
        return res;
    }

    private Batch initBatch(boolean backup) {
        while (this.curBatch.get() == null) {
            long curCntr = this.currPartCntr.applyAsLong(backup ? 1L : 0L);
            if (curCntr == -1L) {
                return null;
            }
            this.curBatch.compareAndSet(null, new Batch(curCntr + 1L, 0L, new CacheContinuousQueryEntry[BUF_SIZE]));
        }
        return this.curBatch.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object processPending(@Nullable Object res, Batch batch, boolean backup) {
        if (this.pending.floorKey(batch.endCntr) == null) {
            return res;
        }
        ConcurrentSkipListMap<Long, CacheContinuousQueryEntry> concurrentSkipListMap = this.pending;
        synchronized (concurrentSkipListMap) {
            for (Map.Entry p : this.pending.headMap((Object)batch.endCntr, true).entrySet()) {
                long cntr = (Long)p.getKey();
                assert (cntr <= batch.endCntr);
                if (this.pending.remove(cntr) == null) continue;
                res = cntr < batch.startCntr ? this.addResult(res, (CacheContinuousQueryEntry)p.getValue(), backup) : batch.processEntry0(res, (Long)p.getKey(), (CacheContinuousQueryEntry)p.getValue(), backup);
                this.pendingCurrSize.decrementAndGet();
            }
            return res;
        }
    }

    @Nullable
    private Object addResult(@Nullable Object res, CacheContinuousQueryEntry entry, boolean backup) {
        if (res == null) {
            if (backup) {
                this.backupQ.add(entry);
            } else {
                res = entry;
            }
        } else {
            List<CacheContinuousQueryEntry> resList;
            assert (!backup);
            if (res instanceof CacheContinuousQueryEntry) {
                resList = new ArrayList<CacheContinuousQueryEntry>();
                resList.add((CacheContinuousQueryEntry)((Object)res));
            } else {
                assert (res instanceof List) : res;
                resList = res;
            }
            resList.add(entry);
            res = resList;
        }
        return res;
    }

    private class Batch {
        private long filtered;
        private final long startCntr;
        private final long endCntr;
        private int lastProc = -1;
        private CacheContinuousQueryEntry[] entries;

        Batch(long startCntr, long filtered, CacheContinuousQueryEntry[] entries) {
            assert (startCntr >= 0L);
            assert (filtered >= 0L);
            this.startCntr = startCntr;
            this.filtered = filtered;
            this.entries = entries;
            this.endCntr = startCntr + (long)BUF_SIZE - 1L;
        }

        synchronized Map<Long, CacheContinuousQueryEntry> flushCurrentEntries(BiFunction<Long, Long, CacheContinuousQueryEntry> filteredFactory) {
            if (this.entries == null || filteredFactory == null) {
                return Collections.emptyMap();
            }
            HashMap<Long, CacheContinuousQueryEntry> res = new HashMap<Long, CacheContinuousQueryEntry>();
            long filtered = this.filtered;
            long cntr = this.startCntr;
            for (int i = 0; i < this.entries.length; ++i) {
                CacheContinuousQueryEntry e = this.entries[i];
                CacheContinuousQueryEntry flushEntry = null;
                if (e == null) {
                    if (filtered != 0L) {
                        flushEntry = filteredFactory.apply(cntr - 1L, filtered - 1L);
                        filtered = 0L;
                    }
                } else if (e.isFiltered()) {
                    ++filtered;
                } else {
                    flushEntry = new CacheContinuousQueryEntry(e.cacheId(), e.eventType(), e.key(), e.value(), e.oldValue(), e.isKeepBinary(), e.partition(), e.updateCounter(), e.topologyVersion(), e.flags());
                    flushEntry.filteredCount(filtered);
                    filtered = 0L;
                }
                if (flushEntry != null) {
                    res.put(flushEntry.updateCounter(), flushEntry);
                }
                ++cntr;
            }
            if (filtered != 0L) {
                CacheContinuousQueryEntry flushEntry = filteredFactory.apply(cntr - 1L, filtered - 1L);
                res.put(flushEntry.updateCounter(), flushEntry);
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private Object processEntry0(@Nullable Object res, long cntr, CacheContinuousQueryEntry entry, boolean backup) {
            int pos = (int)(cntr - this.startCntr);
            Batch batch = this;
            synchronized (batch) {
                if (this.entries == null) {
                    return RETRY;
                }
                this.entries[pos] = entry = entry.copyWithDataReset();
                int next = this.lastProc + 1;
                long ackedUpdCntr0 = CacheContinuousQueryEventBuffer.this.ackedUpdCntr.get();
                if (next == pos) {
                    CacheContinuousQueryEntry entry0;
                    int i = next;
                    while (i < this.entries.length && (entry0 = this.entries[i]) != null) {
                        if (!entry0.isFiltered()) {
                            entry0.filteredCount(this.filtered);
                            this.filtered = 0L;
                            res = CacheContinuousQueryEventBuffer.this.addResult(res, entry0, backup);
                        } else {
                            ++this.filtered;
                        }
                        pos = i++;
                    }
                    this.lastProc = pos;
                    if (pos == this.entries.length - 1) {
                        this.rollOver(this.startCntr + (long)BUF_SIZE, this.filtered);
                    }
                } else if (this.endCntr < ackedUpdCntr0) {
                    this.rollOver(ackedUpdCntr0 + 1L, 0L);
                }
                return res;
            }
        }

        private synchronized Object tryRollOver() {
            if (this.entries == null) {
                return RETRY;
            }
            long ackedUpdCntr0 = CacheContinuousQueryEventBuffer.this.ackedUpdCntr.get();
            if (this.endCntr < ackedUpdCntr0) {
                this.rollOver(ackedUpdCntr0 + 1L, 0L);
                return RETRY;
            }
            return null;
        }

        private void rollOver(long startCntr, long filtered) {
            Arrays.fill(this.entries, null);
            Batch nextBatch = new Batch(startCntr, filtered, this.entries);
            this.entries = null;
            boolean changed = CacheContinuousQueryEventBuffer.this.curBatch.compareAndSet(this, nextBatch);
            assert (changed);
        }
    }
}

