/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIOV2;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MetaPageUpdateIndexDataRecord
extends PageDeltaRecord {
    private int encryptPageIdx;
    private int encryptPageCnt;

    public MetaPageUpdateIndexDataRecord(int grpId, long pageId, int encryptPageIdx, int encryptPageCnt) {
        super(grpId, pageId);
        this.encryptPageIdx = encryptPageIdx;
        this.encryptPageCnt = encryptPageCnt;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        if (PageIO.getVersion(pageAddr) < 2) {
            ((PageMetaIOV2)PageMetaIOV2.VERSIONS.latest()).upgradePage(pageAddr);
        }
        PageMetaIOV2 io = (PageMetaIOV2)PageMetaIOV2.VERSIONS.forPage(pageAddr);
        io.setEncryptedPageIndex(pageAddr, this.encryptPageIdx);
        io.setEncryptedPageCount(pageAddr, this.encryptPageCnt);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.INDEX_META_PAGE_DELTA_RECORD;
    }

    public MetaPageUpdateIndexDataRecord(DataInput in) throws IOException {
        super(in.readInt(), in.readLong());
        this.encryptPageIdx = in.readInt();
        this.encryptPageCnt = in.readInt();
    }

    public void toBytes(ByteBuffer buf) {
        buf.putInt(this.groupId());
        buf.putLong(this.pageId());
        buf.putInt(this.encryptionPagesIndex());
        buf.putInt(this.encryptionPagesCount());
    }

    private int encryptionPagesIndex() {
        return this.encryptPageIdx;
    }

    private int encryptionPagesCount() {
        return this.encryptPageCnt;
    }

    @Override
    public String toString() {
        return S.toString(MetaPageUpdateIndexDataRecord.class, this, "partId", (Object)PageIdUtils.partId(this.pageId()), "super", (Object)super.toString());
    }
}

