/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.spec;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;

public class EdDSAPrivateKeySpec
implements KeySpec {
    private final byte[] seed;
    private final byte[] h;
    private final byte[] a;
    private final GroupElement A;
    private final EdDSAParameterSpec spec;

    public EdDSAPrivateKeySpec(byte[] seed, EdDSAParameterSpec spec) {
        if (seed.length != spec.getCurve().getField().getb() / 8) {
            throw new IllegalArgumentException("seed length is wrong");
        }
        this.spec = spec;
        this.seed = seed;
        try {
            MessageDigest hash = MessageDigest.getInstance(spec.getHashAlgorithm());
            int b = spec.getCurve().getField().getb();
            this.h = hash.digest(seed);
            this.h[0] = (byte)(this.h[0] & 0xF8);
            int n = b / 8 - 1;
            this.h[n] = (byte)(this.h[n] & 0x3F);
            int n2 = b / 8 - 1;
            this.h[n2] = (byte)(this.h[n2] | 0x40);
            this.a = Arrays.copyOfRange(this.h, 0, b / 8);
            this.A = spec.getB().scalarMultiply(this.a);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Unsupported hash algorithm");
        }
    }

    public EdDSAPrivateKeySpec(EdDSAParameterSpec spec, byte[] h) {
        if (h.length != spec.getCurve().getField().getb() / 4) {
            throw new IllegalArgumentException("hash length is wrong");
        }
        this.seed = null;
        this.h = h;
        this.spec = spec;
        int b = spec.getCurve().getField().getb();
        h[0] = (byte)(h[0] & 0xF8);
        int n = b / 8 - 1;
        h[n] = (byte)(h[n] & 0x3F);
        int n2 = b / 8 - 1;
        h[n2] = (byte)(h[n2] | 0x40);
        this.a = Arrays.copyOfRange(h, 0, b / 8);
        this.A = spec.getB().scalarMultiply(this.a);
    }

    public EdDSAPrivateKeySpec(byte[] seed, byte[] h, byte[] a, GroupElement A2, EdDSAParameterSpec spec) {
        this.seed = seed;
        this.h = h;
        this.a = a;
        this.A = A2;
        this.spec = spec;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public byte[] getH() {
        return this.h;
    }

    public byte[] geta() {
        return this.a;
    }

    public GroupElement getA() {
        return this.A;
    }

    public EdDSAParameterSpec getParams() {
        return this.spec;
    }
}

