/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.performancestatistics;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.performancestatistics.VisorPerformanceStatisticsTaskArg;

@GridInternal
@GridVisorManagementTask
public class VisorPerformanceStatisticsTask
extends VisorOneNodeTask<VisorPerformanceStatisticsTaskArg, String> {
    public static final String STATUS_ENABLED = "Enabled.";
    public static final String STATUS_DISABLED = "Disabled.";
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorPerformanceStatisticsTaskArg, String> job(VisorPerformanceStatisticsTaskArg arg) {
        return new VisorPerformanceStatisticsJob(arg, false);
    }

    private static class VisorPerformanceStatisticsJob
    extends VisorJob<VisorPerformanceStatisticsTaskArg, String> {
        private static final long serialVersionUID = 0L;

        protected VisorPerformanceStatisticsJob(VisorPerformanceStatisticsTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected String run(VisorPerformanceStatisticsTaskArg arg) throws IgniteException {
            try {
                switch (arg.operation()) {
                    case START: {
                        this.ignite.context().performanceStatistics().startCollectStatistics();
                        return "Started.";
                    }
                    case STOP: {
                        this.ignite.context().performanceStatistics().stopCollectStatistics();
                        return "Stopped.";
                    }
                    case ROTATE: {
                        this.ignite.context().performanceStatistics().rotateCollectStatistics();
                        return "Rotated.";
                    }
                    case STATUS: {
                        return this.ignite.context().performanceStatistics().enabled() ? VisorPerformanceStatisticsTask.STATUS_ENABLED : VisorPerformanceStatisticsTask.STATUS_DISABLED;
                    }
                }
                throw new IllegalArgumentException("Unknown operation: " + (Object)((Object)arg.operation()));
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }
}

