/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import com.hierynomus.sshj.transport.cipher.BlockCiphers;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import net.schmizz.sshj.common.Base64;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.transport.cipher.Cipher;
import net.schmizz.sshj.transport.cipher.NoneCipher;
import net.schmizz.sshj.transport.digest.MD5;
import net.schmizz.sshj.userauth.keyprovider.BaseFileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;

public class PKCS5KeyFile
extends BaseFileKeyProvider {
    protected byte[] data;

    @Override
    protected KeyPair readKeyPair() throws IOException {
        try (BufferedReader reader = new BufferedReader(this.resource.getReader());){
            String line = null;
            Cipher cipher = new NoneCipher();
            StringBuffer sb = new StringBuffer();
            byte[] iv = new byte[]{};
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("-----BEGIN ") && line.endsWith(" PRIVATE KEY-----")) {
                    int end = line.length() - 17;
                    if (end > 11) {
                        String s = line.substring(11, line.length() - 17);
                        if ("RSA".equals(s)) {
                            this.type = KeyType.RSA;
                            continue;
                        }
                        if ("DSA".equals(s)) {
                            this.type = KeyType.DSA;
                            continue;
                        }
                        if ("DSS".equals(s)) {
                            this.type = KeyType.DSA;
                            continue;
                        }
                        throw new FormatException("Unrecognized PKCS5 key type");
                    }
                    throw new FormatException("Bad header; possibly PKCS8 format?");
                }
                if (line.startsWith("-----END")) break;
                if (this.type == null) continue;
                if (line.startsWith("Proc-Type: ")) {
                    if ("4,ENCRYPTED".equals(line.substring(11))) continue;
                    throw new FormatException("Unrecognized Proc-Type");
                }
                if (line.startsWith("DEK-Info: ")) {
                    int ptr = line.indexOf(",");
                    if (ptr == -1) {
                        throw new FormatException("Unrecognized DEK-Info");
                    }
                    String algorithm = line.substring(10, ptr);
                    if ("DES-EDE3-CBC".equals(algorithm)) {
                        cipher = BlockCiphers.TripleDESCBC().create();
                    } else if ("AES-128-CBC".equals(algorithm)) {
                        cipher = BlockCiphers.AES128CBC().create();
                    } else if ("AES-192-CBC".equals(algorithm)) {
                        cipher = BlockCiphers.AES192CBC().create();
                    } else if ("AES-256-CBC".equals(algorithm)) {
                        cipher = BlockCiphers.AES256CBC().create();
                    } else {
                        throw new FormatException("Not a supported algorithm: " + algorithm);
                    }
                    iv = Arrays.copyOfRange(ByteArrayUtils.parseHex(line.substring(ptr + 1)), 0, cipher.getIVSize());
                    continue;
                }
                if (line.length() <= 0) continue;
                sb.append(line);
            }
            if (this.type == null) {
                throw new FormatException("PKCS5 header not found");
            }
            this.data = this.decrypt(Base64.decode(sb.toString()), cipher, iv);
            ASN1Data asn = new ASN1Data(this.data);
            switch (this.type) {
                case RSA: {
                    KeyFactory factory = KeyFactory.getInstance("RSA");
                    asn.readNext();
                    BigInteger modulus = asn.readNext();
                    BigInteger pubExp = asn.readNext();
                    BigInteger prvExp = asn.readNext();
                    PublicKey pubKey = factory.generatePublic(new RSAPublicKeySpec(modulus, pubExp));
                    PrivateKey prvKey = factory.generatePrivate(new RSAPrivateKeySpec(modulus, prvExp));
                    KeyPair keyPair = new KeyPair(pubKey, prvKey);
                    return keyPair;
                }
                case DSA: {
                    KeyFactory factory = KeyFactory.getInstance("DSA");
                    asn.readNext();
                    BigInteger p = asn.readNext();
                    BigInteger q = asn.readNext();
                    BigInteger g = asn.readNext();
                    BigInteger pub = asn.readNext();
                    BigInteger prv = asn.readNext();
                    PublicKey pubKey = factory.generatePublic(new DSAPublicKeySpec(pub, p, q, g));
                    PrivateKey prvKey = factory.generatePrivate(new DSAPrivateKeySpec(prv, p, q, g));
                    KeyPair keyPair = new KeyPair(pubKey, prvKey);
                    return keyPair;
                }
            }
            try {
                throw new IOException("Unrecognized PKCS5 key type: " + (Object)((Object)this.type));
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
            catch (InvalidKeySpecException e) {
                throw new IOException(e);
            }
        }
    }

    public String toString() {
        return "PKCS5KeyFile{resource=" + this.resource + "}";
    }

    private byte[] getPassphraseBytes() {
        CharBuffer cb = CharBuffer.wrap(this.pwdf.reqPassword(this.resource));
        ByteBuffer bb = IOUtils.UTF8.encode(cb);
        byte[] result = Arrays.copyOfRange(bb.array(), bb.position(), bb.limit());
        Arrays.fill(cb.array(), '\u0000');
        Arrays.fill(bb.array(), (byte)0);
        return result;
    }

    private byte[] decrypt(byte[] raw, Cipher cipher, byte[] iv) throws DecryptException {
        if (this.pwdf == null) {
            return raw;
        }
        MD5 md5 = new MD5();
        int bsize = cipher.getBlockSize();
        int hsize = md5.getBlockSize();
        int hnlen = bsize / hsize * hsize + (bsize % hsize == 0 ? 0 : hsize);
        do {
            md5.init();
            byte[] hn = new byte[hnlen];
            byte[] tmp = null;
            byte[] passphrase = this.getPassphraseBytes();
            int i = 0;
            while (i + hsize <= hn.length) {
                if (tmp != null) {
                    md5.update(tmp, 0, tmp.length);
                }
                md5.update(passphrase, 0, passphrase.length);
                md5.update(iv, 0, iv.length > 8 ? 8 : iv.length);
                tmp = md5.digest();
                System.arraycopy(tmp, 0, hn, i, tmp.length);
                i += tmp.length;
            }
            Arrays.fill(passphrase, (byte)0);
            byte[] key = Arrays.copyOfRange(hn, 0, bsize);
            cipher.init(Cipher.Mode.Decrypt, key, iv);
            Arrays.fill(key, (byte)0);
            byte[] decrypted = Arrays.copyOf(raw, raw.length);
            cipher.update(decrypted, 0, decrypted.length);
            if (48 != decrypted[0]) continue;
            return decrypted;
        } while (this.pwdf.shouldRetry(this.resource));
        throw new DecryptException("Decryption failed");
    }

    class ASN1Data {
        static final byte MAGIC = 48;
        private byte[] buff;
        private int index;
        private int length;

        ASN1Data(byte[] buff) throws FormatException {
            this.buff = buff;
            this.index = 0;
            if (buff[this.index++] != 48) {
                throw new FormatException("Not ASN.1 data");
            }
            this.length = buff[this.index++] & 0xFF;
            if ((this.length & 0x80) != 0) {
                int counter = this.length & 0x7F;
                this.length = 0;
                while (counter-- > 0) {
                    this.length = (this.length << 8) + (buff[this.index++] & 0xFF);
                }
            }
            if (this.index + this.length > buff.length) {
                throw new FormatException("Length mismatch: " + buff.length + " != " + (this.index + this.length));
            }
        }

        BigInteger readNext() throws IOException {
            int length;
            if (this.index >= this.length) {
                throw new EOFException();
            }
            if (this.buff[this.index++] != 2) {
                throw new IOException("Not an int code: " + Integer.toHexString(0xFF & this.buff[this.index]));
            }
            if (((length = this.buff[this.index++] & 0xFF) & 0x80) != 0) {
                int counter = length & 0x7F;
                length = 0;
                while (counter-- > 0) {
                    length = (length << 8) + (this.buff[this.index++] & 0xFF);
                }
            }
            byte[] sequence = new byte[length];
            System.arraycopy(this.buff, this.index, sequence, 0, length);
            this.index += length;
            return new BigInteger(sequence);
        }
    }

    public static class DecryptException
    extends IOException {
        DecryptException(String msg) {
            super(msg);
        }
    }

    public static class FormatException
    extends IOException {
        FormatException(String msg) {
            super(msg);
        }
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new PKCS5KeyFile();
        }

        @Override
        public String getName() {
            return "PKCS5";
        }
    }
}

