/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.test.io;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.utilities.exec.Shell;

public enum WindowsSpecialFolder {
    COMMON_APPLICATION_DATA("CommonApplicationData", true),
    SYSTEM("System", false);

    private final LazyProperty<Path> accessor;
    private static final Logger LOGGER;

    private WindowsSpecialFolder(String identifier, boolean create) {
        Objects.requireNonNull(identifier, "identifier");
        this.accessor = LazyProperty.lazily(() -> WindowsSpecialFolder.getSpecialFolder(identifier, create));
    }

    public Path get() throws IOException {
        return this.accessor.get();
    }

    private static Path getSpecialFolder(String specialFolderId, boolean create) throws IOException {
        Shell.Result result;
        Object[] command = new String[]{"powershell.exe", "-NoLogo", "-NoProfile", "-NonInteractive", "-Command", "&{$ErrorActionPreference = 'Stop'; [environment]::getfolderpath('" + specialFolderId + "'" + (create ? ", 'create'" : "") + ")}"};
        try {
            result = Shell.execute(Shell.Encoding.CHARSET, (String[])command);
        }
        catch (IOException e) {
            LOGGER.error("Unable to determine special folder for {}; {} failed", specialFolderId, Arrays.toString(command), e);
            throw e;
        }
        if (result.exitCode() != 0) {
            SpecialFolderException exception = new SpecialFolderException(specialFolderId, result.lines(), result.exitCode());
            LOGGER.error("Unable to determine special folder for {}", (Object)specialFolderId, (Object)exception);
            throw exception;
        }
        String specialFolder = result.lines().get(0);
        return Paths.get(specialFolder, new String[0]);
    }

    static {
        LOGGER = LoggerFactory.getLogger(WindowsSpecialFolder.class);
    }

    public static class SpecialFolderException
    extends IOException {
        private static final long serialVersionUID = 8319003610562205355L;
        private final int code;

        private SpecialFolderException(String specialFolder, List<String> errorDetail, int code) {
            super("Error determining directory assigned to special folder \"" + specialFolder + "\"; rc=" + code + (errorDetail == null ? "" : "\n    " + String.join((CharSequence)"\n    ", errorDetail)));
            this.code = code;
        }

        public int code() {
            return this.code;
        }
    }

    private static final class LazyProperty<T> {
        private final AtomicReference<T> reference = new AtomicReference();
        private final ThrowingSupplier<T> supplier;

        public static <T> LazyProperty<T> lazily(ThrowingSupplier<T> from) {
            return new LazyProperty<T>(from);
        }

        private LazyProperty(ThrowingSupplier<T> supplier) {
            this.supplier = supplier;
        }

        public T get() throws IOException {
            T t;
            while ((t = this.reference.get()) == null && !this.reference.compareAndSet(null, t = this.supplier.get())) {
            }
            return t;
        }

        @FunctionalInterface
        public static interface ThrowingSupplier<T> {
            public T get() throws IOException;
        }
    }
}

