/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.core.reactor;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.netcrusher.NetCrusher;
import org.netcrusher.NetFreezer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NioScheduler.class);
    private static final long THREAD_TERMINATION_TIMEOUT_MS = 5000L;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setName("NetCrusher scheduled executor");
        thread.setDaemon(false);
        return thread;
    });
    private volatile boolean open = true;

    NioScheduler() {
    }

    synchronized void close() {
        if (this.open) {
            boolean interrupted = false;
            LOGGER.debug("Scheduler is closing");
            this.scheduledExecutorService.shutdownNow();
            try {
                boolean shutdown = this.scheduledExecutorService.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                if (!shutdown) {
                    LOGGER.error("Fail to shutdown scheduled executor service");
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            this.open = false;
            LOGGER.debug("Scheduler is closed");
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public Future<?> execute(Callable<?> callable) {
        return this.scheduledExecutorService.submit(callable);
    }

    public Future<?> execute(Runnable runnable) {
        return this.scheduledExecutorService.submit(runnable);
    }

    public void executeListener(Runnable runnable, boolean deferred) {
        if (deferred) {
            this.execute(runnable);
        } else {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOGGER.error("Exception in listener", e);
            }
        }
    }

    public Future<?> schedule(Callable<?> callable, long delay, TimeUnit timeUnit) {
        return this.scheduledExecutorService.schedule(callable, delay, timeUnit);
    }

    public Future<?> schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
        return this.scheduledExecutorService.schedule(runnable, delay, timeUnit);
    }

    public Future<?> scheduleFreeze(NetFreezer freezer, long delay, TimeUnit timeUnit) {
        return this.scheduledExecutorService.schedule(() -> {
            freezer.freeze();
            return true;
        }, delay, timeUnit);
    }

    public Future<?> scheduleUnfreeze(NetFreezer freezer, long delay, TimeUnit timeUnit) {
        return this.scheduledExecutorService.schedule(() -> {
            freezer.unfreeze();
            return true;
        }, delay, timeUnit);
    }

    public Future<?> scheduleOpen(NetCrusher crusher, long delay, TimeUnit timeUnit) {
        return this.scheduledExecutorService.schedule(() -> {
            crusher.reopen();
            return true;
        }, delay, timeUnit);
    }

    public Future<?> scheduleClose(NetCrusher crusher, long delay, TimeUnit timeUnit) {
        return this.scheduledExecutorService.schedule(() -> {
            crusher.close();
            return true;
        }, delay, timeUnit);
    }

    public Future<?> scheduleReopen(NetCrusher crusher, long delay, TimeUnit timeUnit) {
        return this.scheduledExecutorService.schedule(() -> {
            crusher.reopen();
            return true;
        }, delay, timeUnit);
    }
}

