/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicSingleUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GridDhtAtomicSingleUpdateFuture
extends GridDhtAtomicAbstractUpdateFuture {
    private boolean allUpdated;

    GridDhtAtomicSingleUpdateFuture(GridCacheContext cctx, GridCacheVersion writeVer, GridNearAtomicAbstractUpdateRequest updateReq) {
        super(cctx, writeVer, updateReq);
    }

    @Override
    protected boolean sendAllToDht() {
        return this.allUpdated;
    }

    @Override
    protected void addDhtKey(KeyCacheObject key, List<ClusterNode> dhtNodes) {
        if (this.mappings == null) {
            this.allUpdated = true;
            this.mappings = U.newHashMap(dhtNodes.size());
        }
    }

    @Override
    protected void addNearKey(KeyCacheObject key, GridDhtCacheEntry.ReaderId[] readers) {
        if (this.mappings == null) {
            this.mappings = U.newHashMap(readers.length);
        }
    }

    @Override
    protected GridDhtAtomicAbstractUpdateRequest createRequest(UUID nodeId, long futId, GridCacheVersion writeVer, CacheWriteSynchronizationMode syncMode, @NotNull AffinityTopologyVersion topVer, long ttl, long conflictExpireTime, @Nullable GridCacheVersion conflictVer) {
        if (this.canUseSingleRequest(ttl, conflictExpireTime, conflictVer)) {
            return new GridDhtAtomicSingleUpdateRequest(this.cctx.cacheId(), nodeId, futId, writeVer, syncMode, topVer, this.updateReq.taskNameHash(), this.cctx.deploymentEnabled(), this.updateReq.keepBinary(), this.updateReq.skipStore());
        }
        return new GridDhtAtomicUpdateRequest(this.cctx.cacheId(), nodeId, futId, writeVer, syncMode, topVer, this.updateReq.taskNameHash(), null, this.cctx.deploymentEnabled(), this.updateReq.keepBinary(), this.updateReq.skipStore(), false);
    }

    private boolean canUseSingleRequest(long ttl, long conflictExpireTime, @Nullable GridCacheVersion conflictVer) {
        return ttl == -1L && conflictExpireTime == -1L && conflictVer == null;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAtomicSingleUpdateFuture.class, this, "super", (Object)super.toString());
    }
}

