/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparator;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NullIndexKey;

public class IndexRowCompartorImpl
implements IndexRowComparator {
    @Override
    public int compareKey(long pageAddr, int off, int maxSize, IndexKey key, int curType) {
        if (curType == -1) {
            return -2;
        }
        if (key == NullIndexKey.INSTANCE) {
            return 1;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int compareRow(IndexRow left, IndexRow right, int idx) throws IgniteCheckedException {
        return this.compare(left.key(idx), right.key(idx));
    }

    @Override
    public int compareKey(IndexKey left, IndexKey right) throws IgniteCheckedException {
        if (left == right) {
            return 0;
        }
        return this.compare(left, right);
    }

    private int compare(IndexKey lkey, IndexKey rkey) {
        if (lkey == NullIndexKey.INSTANCE) {
            return lkey.compare(rkey);
        }
        if (rkey == NullIndexKey.INSTANCE) {
            return 1;
        }
        if (lkey.type() == rkey.type()) {
            return lkey.compare(rkey);
        }
        return Integer.MIN_VALUE;
    }
}

