/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.security.AccessControlException;
import java.util.UUID;
import org.apache.ignite.internal.processors.security.AbstractSecurityAwareExternalizable;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.sandbox.IgniteSandbox;
import org.apache.ignite.lang.IgnitePredicate;

public class SecurityAwarePredicate<E>
extends AbstractSecurityAwareExternalizable<IgnitePredicate<E>>
implements IgnitePredicate<E> {
    private static final long serialVersionUID = 0L;

    public SecurityAwarePredicate() {
    }

    public SecurityAwarePredicate(UUID subjectId, IgnitePredicate<E> original) {
        super(subjectId, original);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean apply(E evt) {
        IgniteSecurity security = this.ignite.context().security();
        try (OperationSecurityContext c = security.withContext(this.subjectId);){
            IgniteSandbox sandbox = security.sandbox();
            boolean bl = sandbox.enabled() ? sandbox.execute(() -> ((IgnitePredicate)this.original).apply(evt)).booleanValue() : ((IgnitePredicate)this.original).apply(evt);
            return bl;
        }
        catch (AccessControlException e) {
            this.logAccessDeniedMessage(e);
            throw e;
        }
    }
}

