/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.UUID;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.task.GridTaskWorker;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class ComputeTaskView {
    private final GridTaskWorker worker;
    private final IgniteUuid id;

    public ComputeTaskView(IgniteUuid id, GridTaskWorker worker) {
        this.id = id;
        this.worker = worker;
    }

    @Order
    public IgniteUuid id() {
        return this.id;
    }

    @Order(value=1)
    public IgniteUuid sessionId() {
        return this.worker.getSession().getId();
    }

    @Order(value=2)
    public UUID taskNodeId() {
        return this.worker.getSession().getTaskNodeId();
    }

    public boolean internal() {
        return this.worker.isInternal();
    }

    @Order(value=3)
    public String taskName() {
        return this.worker.getSession().getTaskName();
    }

    @Order(value=4)
    public String taskClassName() {
        return this.worker.getSession().getTaskClassName();
    }

    @Order(value=7)
    public long startTime() {
        return this.worker.getSession().getStartTime();
    }

    @Order(value=8)
    public long endTime() {
        return this.worker.getSession().getEndTime();
    }

    public String execName() {
        return this.worker.getSession().executorName();
    }

    @Order(value=6)
    @Nullable
    public String affinityCacheName() {
        return this.worker.affCacheName();
    }

    @Order(value=5)
    public int affinityPartitionId() {
        return this.worker.affPartId();
    }

    @Deprecated
    public IgniteUuid jobId() {
        return this.worker.getSession().getJobId();
    }

    public String userVersion() {
        return this.worker.getSession().getUserVersion();
    }
}

