/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.marshaller;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.marshaller.MappingExchangeResult;
import org.apache.ignite.internal.processors.marshaller.MarshallerMappingItem;
import org.apache.ignite.internal.processors.marshaller.MissingMappingRequestMessage;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.jetbrains.annotations.Nullable;

final class ClientRequestFuture
extends GridFutureAdapter<MappingExchangeResult> {
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static IgniteLogger log;
    private final GridIoManager ioMgr;
    private final GridDiscoveryManager discoMgr;
    private final MarshallerMappingItem item;
    private final Map<MarshallerMappingItem, ClientRequestFuture> syncMap;
    private final Queue<ClusterNode> aliveSrvNodes;
    private ClusterNode pendingNode;

    ClientRequestFuture(GridKernalContext ctx, MarshallerMappingItem item, Map<MarshallerMappingItem, ClientRequestFuture> syncMap) {
        this.ioMgr = ctx.io();
        this.discoMgr = ctx.discovery();
        this.aliveSrvNodes = new LinkedList<ClusterNode>(this.discoMgr.aliveServerNodes());
        this.item = item;
        this.syncMap = syncMap;
        if (log == null) {
            log = U.logger(ctx, logRef, ClientRequestFuture.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestMapping() {
        boolean noSrvsInCluster;
        ClientRequestFuture clientRequestFuture = this;
        synchronized (clientRequestFuture) {
            while (!this.aliveSrvNodes.isEmpty()) {
                ClusterNode srvNode = this.aliveSrvNodes.poll();
                try {
                    this.ioMgr.sendToGridTopic(srvNode, GridTopic.TOPIC_MAPPING_MARSH, (Message)new MissingMappingRequestMessage(this.item.platformId(), this.item.typeId()), (byte)2);
                    if (this.discoMgr.node(srvNode.id()) == null) continue;
                    this.pendingNode = srvNode;
                    break;
                }
                catch (IgniteCheckedException ignored) {
                    U.warn(log, "Failed to request marshaller mapping from remote node (proceeding with the next one): " + srvNode);
                }
            }
            noSrvsInCluster = this.pendingNode == null;
        }
        if (noSrvsInCluster) {
            this.onDone(MappingExchangeResult.createFailureResult(new IgniteCheckedException("All server nodes have left grid, cannot request mapping [platformId: " + this.item.platformId() + "; typeId: " + this.item.typeId() + "]")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onResponse(UUID nodeId, MappingExchangeResult res) {
        MappingExchangeResult res0 = null;
        ClientRequestFuture clientRequestFuture = this;
        synchronized (clientRequestFuture) {
            if (this.pendingNode != null && this.pendingNode.id().equals(nodeId)) {
                res0 = res;
            }
        }
        if (res0 != null) {
            this.onDone(res0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNodeLeft(UUID leftNodeId) {
        boolean reqAgain = false;
        ClientRequestFuture clientRequestFuture = this;
        synchronized (clientRequestFuture) {
            if (this.pendingNode != null && this.pendingNode.id().equals(leftNodeId)) {
                this.aliveSrvNodes.remove(this.pendingNode);
                this.pendingNode = null;
                reqAgain = true;
            }
        }
        if (reqAgain) {
            this.requestMapping();
        }
    }

    @Override
    public boolean onDone(@Nullable MappingExchangeResult res, @Nullable Throwable err) {
        assert (res != null);
        boolean done = super.onDone(res, err);
        if (done) {
            this.syncMap.remove(this.item);
        }
        return done;
    }
}

