/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class UniversalPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean absolute;
    private final List<String> segments;
    private volatile transient Path cache;

    public static UniversalPath fromLocalPath(Path local) {
        Path root = local.getRoot();
        if (root != null) {
            local = root.relativize(local);
        }
        ArrayList<String> segments = new ArrayList<String>(local.getNameCount());
        for (Path segment : local) {
            segments.add(segment.toString());
        }
        return new UniversalPath(root != null, segments);
    }

    public static UniversalPath create(boolean absolute, List<String> segments) {
        return new UniversalPath(absolute, segments);
    }

    public static UniversalPath create(boolean absolute, String ... segments) {
        return new UniversalPath(absolute, Arrays.asList(segments));
    }

    private UniversalPath(boolean absolute, List<String> segments) {
        this.absolute = absolute;
        for (String segment : segments) {
            if (!segment.contains("/")) continue;
            throw new IllegalArgumentException("Incorrect path: " + segments);
        }
        this.segments = new ArrayList<String>(segments);
    }

    public Path toLocalPath() {
        if (this.cache != null) {
            return this.cache;
        }
        Path rel = Paths.get("", this.segments.toArray(new String[0]));
        this.cache = this.absolute ? FileSystems.getDefault().getRootDirectories().iterator().next().resolve(rel) : rel;
        return this.cache;
    }

    public String toString() {
        return (this.absolute ? "/" : "") + String.join((CharSequence)"/", this.segments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UniversalPath)) {
            return false;
        }
        UniversalPath that = (UniversalPath)o;
        return this.absolute == that.absolute && this.segments.equals(that.segments);
    }

    public int hashCode() {
        return Objects.hash(this.absolute, this.segments);
    }
}

