/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.terracotta.angela.common.util.TimeBudget;

public class RetryUtils {
    public static boolean waitFor(Callable<Boolean> condition, long maxWaitTimeMillis) {
        return RetryUtils.waitFor(condition, maxWaitTimeMillis, TimeUnit.MILLISECONDS, () -> {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    public static boolean waitFor(Callable<Boolean> condition, long maxWaitDuration, TimeUnit timeUnit, Runnable failed) {
        boolean success;
        TimeBudget timeBudget = new TimeBudget(maxWaitDuration, timeUnit);
        do {
            try {
                success = condition.call();
                if (success) continue;
                failed.run();
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
        } while (!success && !Thread.currentThread().isInterrupted() && !timeBudget.isDepleted());
        return success;
    }
}

