/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;

public class JDK {
    private final String home;
    private final String version;
    private final String vendor;

    JDK(String home, String version, String vendor) {
        this.home = home;
        this.version = version;
        this.vendor = vendor;
        if (home.trim().isEmpty()) {
            throw new IllegalArgumentException(home);
        }
    }

    public String getHome() {
        return this.home;
    }

    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    public Optional<String> getVendor() {
        return Optional.ofNullable(this.vendor);
    }

    public String toString() {
        return "JDK{home='" + this.home + '\'' + ", version='" + this.version + '\'' + ", vendor='" + this.vendor + '\'' + '}';
    }

    public boolean canBeLocated() {
        return Files.isDirectory(Paths.get(this.getHome(), new String[0]), new LinkOption[0]);
    }

    public boolean matches(String allowedVersion, Set<String> allowedVendors) {
        return !(allowedVersion != null && !allowedVersion.equalsIgnoreCase(this.version) || !allowedVendors.isEmpty() && !allowedVendors.stream().anyMatch(allowed -> allowed.equalsIgnoreCase(this.vendor)));
    }
}

