/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.net;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.utilities.test.net.PortManager;

public class DefaultPortAllocator
implements PortAllocator {
    private final PortManager portManager = PortManager.getInstance();
    private final Collection<PortManager.PortRef> reservations = new CopyOnWriteArrayList<PortManager.PortRef>();

    @Override
    public PortAllocator.PortReservation reserve(int portCounts) {
        final List portRefs = portCounts < 1 ? Collections.emptyList() : this.portManager.reservePorts(portCounts);
        this.reservations.addAll(portRefs);
        return new PortAllocator.PortReservation(){
            int i = 0;

            @Override
            public Integer next() {
                if (this.i >= portRefs.size()) {
                    throw new NoSuchElementException();
                }
                return ((PortManager.PortRef)portRefs.get(this.i++)).port();
            }

            @Override
            public boolean hasNext() {
                return this.i < portRefs.size();
            }

            @Override
            public void close() {
                for (PortManager.PortRef portRef : portRefs) {
                    if (!DefaultPortAllocator.this.reservations.remove(portRef)) continue;
                    portRef.close();
                }
            }
        };
    }

    @Override
    public void close() {
        while (!this.reservations.isEmpty() && !Thread.currentThread().isInterrupted()) {
            for (PortManager.PortRef portRef : this.reservations) {
                if (!this.reservations.remove(portRef)) continue;
                portRef.close();
            }
        }
    }
}

