/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.com;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.client.RemoteClientManager;
import org.terracotta.angela.agent.com.AgentGroup;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.agent.com.Executor;
import org.terracotta.angela.agent.com.FileTransfer;
import org.terracotta.angela.agent.com.LocalAgentGroup;
import org.terracotta.angela.agent.kit.RemoteKitManager;
import org.terracotta.angela.common.clientconfig.ClientId;
import org.terracotta.angela.common.cluster.Cluster;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.topology.InstanceId;

public class IgniteFreeExecutor
implements Executor {
    private final transient Map<String, BlockingQueue<FileTransfer>> queues = new ConcurrentHashMap<String, BlockingQueue<FileTransfer>>();
    private final AgentGroup agentGroup;

    public IgniteFreeExecutor(Agent agent) {
        this(agent.getGroupId(), agent.getAgentID());
    }

    public IgniteFreeExecutor(UUID group, AgentID agentID) {
        if (!agentID.isLocal()) {
            throw new IllegalArgumentException("Wrong agentID: " + agentID);
        }
        this.agentGroup = new LocalAgentGroup(group, agentID);
    }

    public String toString() {
        return this.getLocalAgentID().toString();
    }

    @Override
    public void close() {
        this.queues.clear();
    }

    @Override
    public synchronized void uploadClientJars(AgentID agentID, InstanceId instanceId, List<Path> locations) {
        CompletableFuture<Void> finished = new CompletableFuture<Void>();
        Thread thread = new Thread(() -> {
            this.downloadFiles(instanceId, new RemoteClientManager(instanceId).getClientClasspathRoot());
            finished.complete(null);
        }, "downloader-" + instanceId);
        thread.start();
        this.uploadFiles(instanceId, locations, finished);
    }

    @Override
    public void uploadKit(AgentID agentID, InstanceId instanceId, Distribution distribution, String kitInstallationName, Path kitInstallationPath) {
        RemoteKitManager remoteKitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
        Path installDir = remoteKitManager.getKitInstallationPath().getParent();
        CompletableFuture<Void> finished = new CompletableFuture<Void>();
        Thread thread = new Thread(() -> {
            this.downloadFiles(instanceId, installDir);
            finished.complete(null);
        }, "downloader-" + instanceId);
        thread.start();
        this.uploadFiles(instanceId, Collections.singletonList(kitInstallationPath), finished);
    }

    @Override
    public Optional<CompletableFuture<Void>> shutdown(AgentID agentID) {
        return Optional.empty();
    }

    @Override
    public AgentID getLocalAgentID() {
        return this.agentGroup.getLocalAgentID();
    }

    @Override
    public Optional<AgentID> findAgentID(String hostname) {
        return Optional.of(this.getLocalAgentID());
    }

    @Override
    public Optional<AgentID> startRemoteAgent(String hostname) {
        return Optional.empty();
    }

    @Override
    public AgentGroup getGroup() {
        return this.agentGroup;
    }

    @Override
    public Cluster getCluster() {
        throw new UnsupportedOperationException("Unsupported in local mode");
    }

    @Override
    public Cluster getCluster(ClientId clientId) {
        throw new UnsupportedOperationException("Unsupported in local mode");
    }

    @Override
    public Future<Void> executeAsync(AgentID agentID, IgniteRunnable job) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            job.run();
            future.complete(null);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public <R> Future<R> executeAsync(AgentID agentID, IgniteCallable<R> job) {
        CompletableFuture future = new CompletableFuture();
        try {
            future.complete(job.call());
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public BlockingQueue<FileTransfer> getFileTransferQueue(InstanceId instanceId) {
        return this.queues.computeIfAbsent(instanceId + "@file-transfer-queue", s -> new LinkedBlockingQueue(500));
    }
}

