/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedBaseMessage;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridDistributedLockRequest
extends GridDistributedBaseMessage {
    private static final long serialVersionUID = 0L;
    private static final int SKIP_STORE_FLAG_MASK = 1;
    private static final int KEEP_BINARY_FLAG_MASK = 2;
    private static final int STORE_USED_FLAG_MASK = 4;
    private UUID nodeId;
    private GridCacheVersion nearXidVer;
    private long threadId;
    private IgniteUuid futId;
    private long timeout;
    private boolean isInTx;
    private boolean isInvalidate;
    private boolean isRead;
    private TransactionIsolation isolation;
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> keys;
    @GridToStringInclude
    private boolean[] retVals;
    @GridDirectTransient
    protected int idx;
    private int txSize;
    private byte flags;

    public GridDistributedLockRequest() {
    }

    public GridDistributedLockRequest(int cacheId, UUID nodeId, @Nullable GridCacheVersion nearXidVer, long threadId, IgniteUuid futId, GridCacheVersion lockVer, boolean isInTx, boolean isRead, TransactionIsolation isolation, boolean isInvalidate, long timeout, int keyCnt, int txSize, boolean skipStore, boolean keepBinary, boolean addDepInfo) {
        super(lockVer, keyCnt, addDepInfo);
        assert (keyCnt > 0);
        assert (futId != null);
        assert (!isInTx || isolation != null);
        this.cacheId = cacheId;
        this.nodeId = nodeId;
        this.nearXidVer = nearXidVer;
        this.threadId = threadId;
        this.futId = futId;
        this.isInTx = isInTx;
        this.isRead = isRead;
        this.isolation = isolation;
        this.isInvalidate = isInvalidate;
        this.timeout = timeout;
        this.txSize = txSize;
        this.retVals = new boolean[keyCnt];
        this.skipStore(skipStore);
        this.keepBinary(keepBinary);
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public GridCacheVersion nearXidVersion() {
        return this.nearXidVer;
    }

    public long threadId() {
        return this.threadId;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public boolean inTx() {
        return this.isInTx;
    }

    public boolean isInvalidate() {
        return this.isInvalidate;
    }

    public boolean txRead() {
        return this.isRead;
    }

    public boolean returnValue(int idx) {
        return this.retVals[idx];
    }

    private void skipStore(boolean skipStore) {
        this.flags = skipStore ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public boolean skipStore() {
        return (this.flags & 1) == 1;
    }

    public void keepBinary(boolean keepBinary) {
        this.flags = keepBinary ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    public boolean keepBinary() {
        return (this.flags & 2) != 0;
    }

    public boolean storeUsed() {
        return (this.flags & 4) != 0;
    }

    public void storeUsed(boolean storeUsed) {
        this.flags = storeUsed ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    public TransactionIsolation isolation() {
        return this.isolation;
    }

    public int txSize() {
        return this.txSize;
    }

    public void addKeyBytes(KeyCacheObject key, boolean retVal, GridCacheContext ctx) throws IgniteCheckedException {
        if (this.keys == null) {
            this.keys = new ArrayList<KeyCacheObject>(this.keysCount());
        }
        this.keys.add(key);
        this.retVals[this.idx] = retVal;
        ++this.idx;
    }

    public List<KeyCacheObject> keys() {
        return this.keys;
    }

    @Override
    public int partition() {
        return this.keys != null && !this.keys.isEmpty() ? this.keys.get(0).partition() : -1;
    }

    public long timeout() {
        return this.timeout;
    }

    @Override
    public IgniteLogger messageLogger(GridCacheSharedContext ctx) {
        return ctx.txLockMessageLogger();
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.prepareMarshalCacheObjects(this.keys, cctx);
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.finishUnmarshalCacheObjects(this.keys, cctx, ldr);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 8: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeBoolean("isInTx", this.isInTx)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeBoolean("isInvalidate", this.isInvalidate)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeBoolean("isRead", this.isRead)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeByte("isolation", this.isolation != null ? (byte)this.isolation.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeCollection("keys", this.keys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeMessage("nearXidVer", this.nearXidVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeUuid("nodeId", this.nodeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 17: {
                if (!writer.writeBooleanArray("retVals", this.retVals)) {
                    return false;
                }
                writer.incrementState();
            }
            case 18: {
                if (!writer.writeLong("threadId", this.threadId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 19: {
                if (!writer.writeLong("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 20: {
                if (!writer.writeInt("txSize", this.txSize)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 8: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.isInTx = reader.readBoolean("isInTx");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.isInvalidate = reader.readBoolean("isInvalidate");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.isRead = reader.readBoolean("isRead");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                byte isolationOrd = reader.readByte("isolation");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.isolation = TransactionIsolation.fromOrdinal(isolationOrd);
                reader.incrementState();
            }
            case 14: {
                this.keys = (List)reader.readCollection("keys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.nearXidVer = (GridCacheVersion)reader.readMessage("nearXidVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.nodeId = reader.readUuid("nodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 17: {
                this.retVals = reader.readBooleanArray("retVals");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 18: {
                this.threadId = reader.readLong("threadId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 19: {
                this.timeout = reader.readLong("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 20: {
                this.txSize = reader.readInt("txSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDistributedLockRequest.class);
    }

    @Override
    public short directType() {
        return 21;
    }

    @Override
    public byte fieldsCount() {
        return 21;
    }

    @Override
    public String toString() {
        return S.toString(GridDistributedLockRequest.class, this, "keysCnt", (Object)this.retVals.length, "super", (Object)super.toString());
    }
}

