/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.executor;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.compute.ComputeTaskTimeoutCheckedException;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;

public class GridExecutorService
implements ExecutorService,
Externalizable {
    private static final long serialVersionUID = 0L;
    private ClusterGroupAdapter prj;
    private GridKernalContext ctx;
    private IgniteLogger log;
    private boolean isBeingShutdown;
    private List<IgniteInternalFuture<?>> futs = new ArrayList();
    private TaskTerminateListener lsnr = new TaskTerminateListener();
    private final Object mux = new Object();

    public GridExecutorService() {
    }

    public GridExecutorService(ClusterGroupAdapter prj, GridKernalContext ctx) {
        assert (prj != null);
        assert (ctx != null);
        this.prj = prj;
        this.ctx = ctx;
        this.log = ctx.log(GridExecutorService.class);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.prj);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.prj = (ClusterGroupAdapter)in.readObject();
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.prj.executorService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.mux;
        synchronized (object) {
            if (this.isBeingShutdown) {
                return;
            }
            this.isBeingShutdown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        ArrayList cpFuts;
        Iterator iterator = this.mux;
        synchronized (iterator) {
            cpFuts = new ArrayList(this.futs);
            this.isBeingShutdown = true;
        }
        for (IgniteInternalFuture igniteInternalFuture : cpFuts) {
            try {
                igniteInternalFuture.cancel();
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to cancel task: " + igniteInternalFuture, e);
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        Object object = this.mux;
        synchronized (object) {
            return this.isBeingShutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        Object object = this.mux;
        synchronized (object) {
            return this.isBeingShutdown && this.futs.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList locTasks;
        long startNanos = System.nanoTime();
        if ((timeout = TimeUnit.MILLISECONDS.convert(timeout, unit)) <= 0L) {
            timeout = Long.MAX_VALUE;
        }
        Object object = this.mux;
        synchronized (object) {
            locTasks = new ArrayList(this.futs);
        }
        Iterator iter = locTasks.iterator();
        long passedMillis = 0L;
        while (iter.hasNext() && passedMillis < timeout) {
            block8: {
                IgniteInternalFuture fut = (IgniteInternalFuture)iter.next();
                try {
                    fut.get(timeout - passedMillis);
                }
                catch (ComputeTaskTimeoutCheckedException e) {
                    U.error(this.log, "Failed to get task result: " + fut, e);
                    return false;
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to get task result: " + fut, e);
                    if (!(e.getCause() instanceof InterruptedException)) break block8;
                    throw new InterruptedException("Got interrupted while waiting for task completion.");
                }
            }
            passedMillis = U.millisSinceNanos(startNanos);
        }
        return true;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        A.notNull(task, "task != null");
        this.checkShutdown();
        this.ctx.gateway().readLock();
        try {
            Future<T> future = this.addFuture(this.ctx.closure().callAsync(GridClosureCallMode.BALANCE, task, this.prj.nodes()));
            return future;
        }
        finally {
            this.ctx.gateway().readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(Runnable task, final T res) {
        A.notNull(task, "task != null");
        this.checkShutdown();
        this.ctx.gateway().readLock();
        try {
            IgniteInternalFuture fut = this.ctx.closure().runAsync(GridClosureCallMode.BALANCE, task, this.prj.nodes()).chain(new CX1<IgniteInternalFuture<?>, T>(){

                @Override
                public T applyx(IgniteInternalFuture<?> fut) throws IgniteCheckedException {
                    fut.get();
                    return res;
                }
            });
            Future future = this.addFuture(fut);
            return future;
        }
        finally {
            this.ctx.gateway().readUnlock();
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        A.notNull(task, "task != null");
        this.checkShutdown();
        this.ctx.gateway().readLock();
        try {
            Future<?> future = this.addFuture(this.ctx.closure().runAsync(GridClosureCallMode.BALANCE, task, this.prj.nodes()));
            return future;
        }
        finally {
            this.ctx.gateway().readUnlock();
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.invokeAll(tasks, 0L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        A.notNull(tasks, "tasks != null");
        A.ensure(timeout >= 0L, "timeout >= 0");
        A.notNull((Object)unit, "unit != null");
        long startNanos = System.nanoTime();
        timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
        if (timeout <= 0L) {
            timeout = Long.MAX_VALUE;
        }
        this.checkShutdown();
        ArrayList<ComputeTaskInternalFuture<T>> taskFuts = new ArrayList<ComputeTaskInternalFuture<T>>();
        long passedMillis = 0L;
        for (Callable<T> callable : tasks) {
            ComputeTaskInternalFuture<T> fut;
            this.ctx.gateway().readLock();
            try {
                fut = this.ctx.closure().callAsync(GridClosureCallMode.BALANCE, callable, this.prj.nodes());
            }
            finally {
                this.ctx.gateway().readUnlock();
            }
            taskFuts.add(fut);
            passedMillis = U.millisSinceNanos(startNanos);
        }
        boolean isInterrupted = false;
        for (ComputeTaskInternalFuture<T> fut : taskFuts) {
            block15: {
                if (!isInterrupted && passedMillis < timeout) {
                    try {
                        fut.get(timeout - passedMillis);
                    }
                    catch (ComputeTaskTimeoutCheckedException computeTaskTimeoutCheckedException) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Timeout occurred during getting task result: " + fut);
                        }
                        this.cancelFuture(fut);
                    }
                    catch (IgniteCheckedException igniteCheckedException) {
                        if (!(igniteCheckedException.getCause() instanceof InterruptedException)) break block15;
                        isInterrupted = true;
                        this.cancelFuture(fut);
                    }
                }
            }
            passedMillis = U.millisSinceNanos(startNanos);
        }
        if (isInterrupted) {
            throw new InterruptedException("Got interrupted while waiting for tasks invocation.");
        }
        ArrayList<Future<T>> arrayList = new ArrayList<Future<T>>(taskFuts.size());
        for (IgniteInternalFuture igniteInternalFuture : taskFuts) {
            if (!igniteInternalFuture.isDone()) {
                this.cancelFuture(igniteInternalFuture);
            }
            arrayList.add(new TaskFutureWrapper(igniteInternalFuture));
        }
        return arrayList;
    }

    private void cancelFuture(IgniteInternalFuture<?> fut) {
        try {
            fut.cancel();
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to cancel task: " + fut, e);
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.invokeAny(tasks, 0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException("Timeout occurred during commands execution.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        A.notNull(tasks, "tasks != null");
        A.ensure(!tasks.isEmpty(), "!tasks.isEmpty()");
        A.ensure(timeout >= 0L, "timeout >= 0");
        A.notNull((Object)unit, "unit != null");
        long startNanos = System.nanoTime();
        timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
        if (timeout <= 0L) {
            timeout = Long.MAX_VALUE;
        }
        this.checkShutdown();
        ArrayList<ComputeTaskInternalFuture<T>> taskFuts = new ArrayList<ComputeTaskInternalFuture<T>>();
        for (Callable<T> cmd : tasks) {
            ComputeTaskInternalFuture<T> fut;
            this.ctx.gateway().readLock();
            try {
                fut = this.ctx.closure().callAsync(GridClosureCallMode.BALANCE, cmd, this.prj.nodes());
            }
            finally {
                this.ctx.gateway().readUnlock();
            }
            taskFuts.add(fut);
        }
        T res = null;
        boolean isInterrupted = false;
        boolean isResRcvd = false;
        int errCnt = 0;
        for (IgniteInternalFuture igniteInternalFuture : taskFuts) {
            long passedMillis = U.millisSinceNanos(startNanos);
            boolean cancel = false;
            if (!isInterrupted && !isResRcvd && passedMillis < timeout) {
                try {
                    res = (T)igniteInternalFuture.get(timeout - passedMillis);
                    isResRcvd = true;
                    continue;
                }
                catch (IgniteFutureTimeoutCheckedException ignored) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Timeout occurred during getting task result: " + igniteInternalFuture);
                    }
                    cancel = true;
                }
                catch (IgniteCheckedException e) {
                    if (e.getCause() instanceof InterruptedException) {
                        isInterrupted = true;
                    }
                    ++errCnt;
                }
            }
            if (!isInterrupted && !isResRcvd && !cancel || igniteInternalFuture.isDone()) continue;
            this.cancelFuture(igniteInternalFuture);
        }
        if (isInterrupted) {
            throw new InterruptedException("Got interrupted while waiting for tasks invocation.");
        }
        if (!isResRcvd && taskFuts.size() == errCnt) {
            throw new ExecutionException("Failed to get any task completion.", null);
        }
        if (!isResRcvd) {
            throw new TimeoutException("Timeout occurred during tasks invocation.");
        }
        return res;
    }

    @Override
    public void execute(Runnable cmd) {
        A.notNull(cmd, "cmd != null");
        this.checkShutdown();
        this.ctx.gateway().readLock();
        try {
            this.addFuture(this.ctx.closure().runAsync(GridClosureCallMode.BALANCE, cmd, this.prj.nodes()));
        }
        finally {
            this.ctx.gateway().readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdown() {
        Object object = this.mux;
        synchronized (object) {
            if (this.isBeingShutdown) {
                throw new RejectedExecutionException("Failed to execute command during executor shutdown.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Future<T> addFuture(IgniteInternalFuture<T> fut) {
        Object object = this.mux;
        synchronized (object) {
            if (!fut.isDone()) {
                fut.listen(this.lsnr);
                this.futs.add(fut);
            }
            return new TaskFutureWrapper<T>(fut);
        }
    }

    private class TaskFutureWrapper<T>
    implements Future<T> {
        private final IgniteInternalFuture<T> fut;

        TaskFutureWrapper(IgniteInternalFuture<T> fut) {
            assert (fut != null);
            this.fut = fut;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                this.fut.cancel();
            }
            catch (IgniteCheckedException e) {
                U.error(GridExecutorService.this.log, "Failed to cancel task: " + this.fut, e);
            }
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.fut.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.fut.isDone();
        }

        @Override
        public T get() throws ExecutionException {
            try {
                T res = this.fut.get();
                if (this.fut.isCancelled()) {
                    throw new CancellationException("Task was cancelled: " + this.fut);
                }
                return res;
            }
            catch (IgniteCheckedException e) {
                if (this.fut.isCancelled()) {
                    CancellationException ex = new CancellationException("Task was cancelled: " + this.fut);
                    ex.initCause(e);
                    throw ex;
                }
                throw new ExecutionException("Failed to get task result: " + this.fut, e);
            }
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
            A.ensure(timeout >= 0L, "timeout >= 0");
            A.notNull((Object)unit, "unit != null");
            try {
                T res = this.fut.get(unit.toMillis(timeout));
                if (this.fut.isCancelled()) {
                    throw new CancellationException("Task was cancelled: " + this.fut);
                }
                return res;
            }
            catch (IgniteFutureTimeoutCheckedException e) {
                TimeoutException e2 = new TimeoutException();
                e2.initCause(e);
                throw e2;
            }
            catch (ComputeTaskTimeoutCheckedException e) {
                throw new ExecutionException("Task execution timed out during waiting for task result: " + this.fut, e);
            }
            catch (IgniteCheckedException e) {
                if (this.fut.isCancelled()) {
                    CancellationException ex = new CancellationException("Task was cancelled: " + this.fut);
                    ex.initCause(e);
                    throw ex;
                }
                throw new ExecutionException("Failed to get task result.", e);
            }
        }
    }

    private class TaskTerminateListener<T>
    implements IgniteInClosure<IgniteInternalFuture<T>> {
        private static final long serialVersionUID = 0L;

        private TaskTerminateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(IgniteInternalFuture<T> taskFut) {
            Object object = GridExecutorService.this.mux;
            synchronized (object) {
                GridExecutorService.this.futs.remove(taskFut);
            }
        }
    }
}

