/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.distribution;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaManagementServerInstance;
import org.terracotta.angela.common.TerracottaServerHandle;
import org.terracotta.angela.common.TerracottaVoter;
import org.terracotta.angela.common.TerracottaVoterInstance;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.tms.security.config.TmsServerSecurityConfig;
import org.terracotta.angela.common.topology.Topology;

public abstract class DistributionController {
    protected final Distribution distribution;

    DistributionController(Distribution distribution) {
        this.distribution = distribution;
    }

    public abstract TerracottaServerHandle createTsa(TerracottaServer var1, File var2, File var3, Topology var4, Map<ServerSymbolicName, Integer> var5, TerracottaCommandLineEnvironment var6, Map<String, String> var7, List<String> var8, Duration var9);

    public abstract TerracottaManagementServerInstance.TerracottaManagementServerInstanceProcess startTms(File var1, File var2, TerracottaCommandLineEnvironment var3, Map<String, String> var4);

    public abstract void stopTms(File var1, TerracottaManagementServerInstance.TerracottaManagementServerInstanceProcess var2, TerracottaCommandLineEnvironment var3);

    public abstract TerracottaVoterInstance.TerracottaVoterInstanceProcess startVoter(TerracottaVoter var1, File var2, File var3, SecurityRootDirectory var4, TerracottaCommandLineEnvironment var5, Map<String, String> var6);

    public abstract void stopVoter(TerracottaVoterInstance.TerracottaVoterInstanceProcess var1);

    public abstract ToolExecutionResult invokeClusterTool(File var1, File var2, SecurityRootDirectory var3, TerracottaCommandLineEnvironment var4, Map<String, String> var5, String ... var6);

    public abstract ToolExecutionResult configureCluster(File var1, File var2, Topology var3, Map<ServerSymbolicName, Integer> var4, License var5, SecurityRootDirectory var6, TerracottaCommandLineEnvironment var7, Map<String, String> var8, String ... var9);

    public abstract ToolExecutionResult invokeConfigTool(File var1, File var2, SecurityRootDirectory var3, TerracottaCommandLineEnvironment var4, Map<String, String> var5, String ... var6);

    public abstract ToolExecutionResult activateCluster(File var1, File var2, License var3, SecurityRootDirectory var4, TerracottaCommandLineEnvironment var5, Map<String, String> var6, String ... var7);

    public abstract URI tsaUri(Collection<TerracottaServer> var1, Map<ServerSymbolicName, Integer> var2);

    public abstract String clientJarsRootFolderName(Distribution var1);

    public abstract String pluginJarsRootFolderName(Distribution var1);

    public abstract String terracottaInstallationRoot();

    public abstract void prepareTMS(File var1, File var2, TmsServerSecurityConfig var3);

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    protected void prepareTMS(Properties properties, File tmcPropertiesOutput, TmsServerSecurityConfig tmsServerSecurityConfig, File workDir) {
        tmcPropertiesOutput.getParentFile().mkdirs();
        Map<Object, Object> props = tmsServerSecurityConfig == null ? Collections.emptyMap() : tmsServerSecurityConfig.toMap();
        String auditDir = (String)props.get("tms.security.audit.directory");
        if (auditDir != null && !auditDir.isEmpty()) {
            File path = new File(auditDir);
            if (!path.isAbsolute()) {
                path = new File(workDir, path.getPath());
            }
            path.mkdirs();
        }
        props.forEach((key, value) -> {
            if (value == null) {
                properties.remove(key);
            } else {
                properties.put(key, value);
            }
        });
        try (FileOutputStream outputStream = new FileOutputStream(tmcPropertiesOutput);){
            properties.store(outputStream, null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to enable security in TMS tmc.properties file", ex);
        }
    }
}

