/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.IgniteCodeGeneratingFail;
import org.apache.ignite.internal.binary.BinaryClassDescriptor;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.binary.BinaryPrimitives;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryReaderHandles;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinarySerializedFieldComparator;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectAdapter;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

@IgniteCodeGeneratingFail
public final class BinaryObjectImpl
extends BinaryObjectExImpl
implements Externalizable,
KeyCacheObject {
    private static final long serialVersionUID = 0L;
    @GridDirectTransient
    private BinaryContext ctx;
    private byte[] arr;
    private int start;
    @GridDirectTransient
    private Object obj;
    @GridDirectTransient
    private boolean detachAllowed;
    private int part = -1;

    public BinaryObjectImpl() {
    }

    public BinaryObjectImpl(BinaryContext ctx, byte[] arr, int start) {
        assert (ctx != null);
        assert (arr != null);
        this.ctx = ctx;
        this.arr = arr;
        this.start = start;
    }

    @Override
    public KeyCacheObject copy(int part) {
        if (this.part == part) {
            return this;
        }
        BinaryObjectImpl cp = new BinaryObjectImpl(this.ctx, this.arr, this.start);
        cp.part = part;
        return cp;
    }

    @Override
    public int partition() {
        return this.part;
    }

    @Override
    public void partition(int part) {
        this.part = part;
    }

    @Override
    public byte cacheObjectType() {
        return 100;
    }

    @Override
    public boolean isPlatformType() {
        return false;
    }

    @Override
    public boolean internal() {
        return false;
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectValueContext ctx, boolean cpy) {
        return this.value(ctx, cpy, null);
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectValueContext ctx, boolean cpy, ClassLoader ldr) {
        Object obj0 = this.obj;
        if (obj0 == null || cpy && this.needCopy(ctx)) {
            obj0 = ldr != null ? this.deserialize(ldr) : this.deserializeValue(ctx);
        }
        return (T)obj0;
    }

    @Override
    public byte[] valueBytes(CacheObjectValueContext ctx) throws IgniteCheckedException {
        if (this.detached()) {
            return this.array();
        }
        int len = this.length();
        byte[] arr0 = new byte[len];
        U.arrayCopy(this.arr, this.start, arr0, 0, len);
        return arr0;
    }

    @Override
    public boolean putValue(ByteBuffer buf) throws IgniteCheckedException {
        return this.putValue(buf, 0, CacheObjectAdapter.objectPutSize(this.length()));
    }

    @Override
    public int putValue(long addr) throws IgniteCheckedException {
        return CacheObjectAdapter.putValue(addr, this.cacheObjectType(), this.arr, this.start, this.length());
    }

    @Override
    public boolean putValue(ByteBuffer buf, int off, int len) throws IgniteCheckedException {
        return CacheObjectAdapter.putValue(this.cacheObjectType(), buf, off, len, this.arr, this.start);
    }

    @Override
    public int valueBytesLength(CacheObjectContext ctx) throws IgniteCheckedException {
        return CacheObjectAdapter.objectPutSize(this.length());
    }

    @Override
    public CacheObject prepareForCache(CacheObjectContext ctx) {
        if (this.detached()) {
            return this;
        }
        return this.detach();
    }

    @Override
    public void finishUnmarshal(CacheObjectValueContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        CacheObjectBinaryProcessorImpl binaryProc = (CacheObjectBinaryProcessorImpl)ctx.kernalContext().cacheObjects();
        this.ctx = binaryProc.binaryContext();
        binaryProc.waitMetadataWriteIfNeeded(this.typeId());
    }

    @Override
    public void prepareMarshal(CacheObjectValueContext ctx) throws IgniteCheckedException {
    }

    @Override
    public int length() {
        return BinaryPrimitives.readInt(this.arr, this.start + 12);
    }

    public BinaryObjectImpl detach() {
        if (!this.detachAllowed || this.detached()) {
            return this;
        }
        int len = this.length();
        byte[] arr0 = new byte[len];
        U.arrayCopy(this.arr, this.start, arr0, 0, len);
        return new BinaryObjectImpl(this.ctx, arr0, 0);
    }

    public boolean detached() {
        return this.start == 0 && this.length() == this.arr.length;
    }

    public void detachAllowed(boolean detachAllowed) {
        this.detachAllowed = detachAllowed;
    }

    @Override
    public BinaryContext context() {
        return this.ctx;
    }

    public void context(BinaryContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public byte[] array() {
        return this.arr;
    }

    @Override
    public int start() {
        return this.start;
    }

    @Override
    public long offheapAddress() {
        return 0L;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public boolean isFlagSet(short flag) {
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        return BinaryUtils.isFlagSet(flags, flag);
    }

    @Override
    public int typeId() {
        int off = this.start + 4;
        int typeId = BinaryPrimitives.readInt(this.arr, off);
        if (typeId == 0) {
            off = this.start + 24;
            assert (this.arr[off] == 9) : this.arr[off];
            int len = BinaryPrimitives.readInt(this.arr, ++off);
            String clsName = new String(this.arr, off + 4, len, StandardCharsets.UTF_8);
            typeId = this.ctx.typeId(clsName);
        }
        return typeId;
    }

    @Override
    @Nullable
    public BinaryType type() throws BinaryObjectException {
        return BinaryUtils.typeProxy(this.ctx, this);
    }

    @Override
    @Nullable
    public BinaryType rawType() throws BinaryObjectException {
        return BinaryUtils.type(this.ctx, this);
    }

    @Override
    @Nullable
    public <F> F field(String fieldName) throws BinaryObjectException {
        return (F)this.reader(null, false).unmarshalField(fieldName);
    }

    @Override
    @Nullable
    public <F> F field(int fieldId) throws BinaryObjectException {
        return (F)this.reader(null, false).unmarshalField(fieldId);
    }

    @Override
    public BinarySerializedFieldComparator createFieldComparator() {
        int schemaOff = BinaryPrimitives.readInt(this.arr, this.start + 20);
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        int fieldIdLen = BinaryUtils.isCompactFooter(flags) ? 0 : 4;
        int fieldOffLen = BinaryUtils.fieldOffsetLength(flags);
        int orderBase = this.start + schemaOff + fieldIdLen;
        int orderMultiplier = fieldIdLen + fieldOffLen;
        return new BinarySerializedFieldComparator(this, this.arr, 0L, this.start, orderBase, orderMultiplier, fieldOffLen);
    }

    @Override
    public int dataStartOffset() {
        int typeId = BinaryPrimitives.readInt(this.arr, this.start + 4);
        if (typeId == 0) {
            int len = BinaryPrimitives.readInt(this.arr, this.start + 24 + 1);
            return this.start + 24 + len + 5;
        }
        return this.start + 24;
    }

    @Override
    public int footerStartOffset() {
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        if (!BinaryUtils.hasSchema(flags)) {
            return this.start + this.length();
        }
        return this.start + BinaryPrimitives.readInt(this.arr, this.start + 20);
    }

    @Override
    @Nullable
    public <F> F fieldByOrder(int order) {
        Object val;
        if (order == -1) {
            return null;
        }
        int schemaOff = BinaryPrimitives.readInt(this.arr, this.start + 20);
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        int fieldIdLen = BinaryUtils.isCompactFooter(flags) ? 0 : 4;
        int fieldOffLen = BinaryUtils.fieldOffsetLength(flags);
        int fieldOffsetPos = this.start + schemaOff + order * (fieldIdLen + fieldOffLen) + fieldIdLen;
        int fieldPos = fieldOffLen == 1 ? this.start + (BinaryPrimitives.readByte(this.arr, fieldOffsetPos) & 0xFF) : (fieldOffLen == 2 ? this.start + (BinaryPrimitives.readShort(this.arr, fieldOffsetPos) & 0xFFFF) : this.start + BinaryPrimitives.readInt(this.arr, fieldOffsetPos));
        byte hdr = BinaryPrimitives.readByte(this.arr, fieldPos);
        switch (hdr) {
            case 3: {
                val = BinaryPrimitives.readInt(this.arr, fieldPos + 1);
                break;
            }
            case 4: {
                val = BinaryPrimitives.readLong(this.arr, fieldPos + 1);
                break;
            }
            case 8: {
                val = BinaryPrimitives.readBoolean(this.arr, fieldPos + 1);
                break;
            }
            case 2: {
                val = BinaryPrimitives.readShort(this.arr, fieldPos + 1);
                break;
            }
            case 1: {
                val = BinaryPrimitives.readByte(this.arr, fieldPos + 1);
                break;
            }
            case 7: {
                val = Character.valueOf(BinaryPrimitives.readChar(this.arr, fieldPos + 1));
                break;
            }
            case 5: {
                val = Float.valueOf(BinaryPrimitives.readFloat(this.arr, fieldPos + 1));
                break;
            }
            case 6: {
                val = BinaryPrimitives.readDouble(this.arr, fieldPos + 1);
                break;
            }
            case 9: {
                int dataLen = BinaryPrimitives.readInt(this.arr, fieldPos + 1);
                val = new String(this.arr, fieldPos + 5, dataLen, StandardCharsets.UTF_8);
                break;
            }
            case 11: {
                long time = BinaryPrimitives.readLong(this.arr, fieldPos + 1);
                val = new Date(time);
                break;
            }
            case 33: {
                long time = BinaryPrimitives.readLong(this.arr, fieldPos + 1);
                int nanos = BinaryPrimitives.readInt(this.arr, fieldPos + 1 + 8);
                Timestamp ts = new Timestamp(time);
                ts.setNanos(ts.getNanos() + nanos);
                val = ts;
                break;
            }
            case 36: {
                long time = BinaryPrimitives.readLong(this.arr, fieldPos + 1);
                val = new Time(time);
                break;
            }
            case 10: {
                long most = BinaryPrimitives.readLong(this.arr, fieldPos + 1);
                long least = BinaryPrimitives.readLong(this.arr, fieldPos + 1 + 8);
                val = new UUID(most, least);
                break;
            }
            case 30: {
                boolean negative;
                int scale = BinaryPrimitives.readInt(this.arr, fieldPos + 1);
                int dataLen = BinaryPrimitives.readInt(this.arr, fieldPos + 5);
                byte[] data = BinaryPrimitives.readByteArray(this.arr, fieldPos + 9, dataLen);
                boolean bl = negative = data[0] < 0;
                if (negative) {
                    data[0] = (byte)(data[0] & 0x7F);
                }
                BigInteger intVal = new BigInteger(data);
                if (negative) {
                    intVal = intVal.negate();
                }
                val = new BigDecimal(intVal, scale);
                break;
            }
            case 101: {
                val = null;
                break;
            }
            default: {
                val = BinaryUtils.unmarshal(BinaryHeapInputStream.create(this.arr, fieldPos), this.ctx, null);
            }
        }
        return (F)val;
    }

    @Override
    public boolean writeFieldByOrder(int order, ByteBuffer buf) {
        int totalLen;
        int schemaOffset = BinaryPrimitives.readInt(this.arr, this.start + 20);
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        int fieldIdLen = BinaryUtils.isCompactFooter(flags) ? 0 : 4;
        int fieldOffsetLen = BinaryUtils.fieldOffsetLength(flags);
        int fieldOffsetPos = this.start + schemaOffset + order * (fieldIdLen + fieldOffsetLen) + fieldIdLen;
        int fieldPos = fieldOffsetLen == 1 ? this.start + (BinaryPrimitives.readByte(this.arr, fieldOffsetPos) & 0xFF) : (fieldOffsetLen == 2 ? this.start + (BinaryPrimitives.readShort(this.arr, fieldOffsetPos) & 0xFFFF) : this.start + BinaryPrimitives.readInt(this.arr, fieldOffsetPos));
        byte hdr = BinaryPrimitives.readByte(this.arr, fieldPos);
        switch (hdr) {
            case 101: {
                totalLen = 1;
                break;
            }
            case 3: 
            case 5: {
                totalLen = 5;
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 36: {
                totalLen = 9;
                break;
            }
            case 8: {
                totalLen = 2;
                break;
            }
            case 2: {
                totalLen = 3;
                break;
            }
            case 1: {
                totalLen = 2;
                break;
            }
            case 7: {
                totalLen = 3;
                break;
            }
            case 9: {
                int dataLen = BinaryPrimitives.readInt(this.arr, fieldPos + 1);
                totalLen = dataLen + 5;
                break;
            }
            case 33: {
                totalLen = 13;
                break;
            }
            case 10: {
                totalLen = 17;
                break;
            }
            case 30: {
                int dataLen = BinaryPrimitives.readInt(this.arr, fieldPos + 5);
                totalLen = dataLen + 9;
                break;
            }
            case 103: {
                totalLen = BinaryPrimitives.readInt(this.arr, fieldPos + 12);
                break;
            }
            case -2: {
                totalLen = BinaryPrimitives.readInt(this.arr, fieldPos + 1);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Failed to write field of the given type (field type is not supported): " + hdr);
            }
        }
        if (buf.remaining() < totalLen) {
            return false;
        }
        buf.put(this.arr, fieldPos, totalLen);
        return true;
    }

    @Override
    @Nullable
    protected <F> F field(BinaryReaderHandles rCtx, String fieldName) {
        return (F)this.reader(rCtx, false).unmarshalField(fieldName);
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.reader(null, false).findFieldByName(fieldName);
    }

    @Override
    @Nullable
    public <T> T deserialize(@Nullable ClassLoader ldr) throws BinaryObjectException {
        if (ldr == null) {
            return this.deserialize();
        }
        GridBinaryMarshaller.USE_CACHE.set(Boolean.FALSE);
        try {
            Object object = this.reader(null, ldr, true).deserialize();
            return (T)object;
        }
        finally {
            GridBinaryMarshaller.USE_CACHE.set(Boolean.TRUE);
        }
    }

    @Override
    @Nullable
    public <T> T deserialize() throws BinaryObjectException {
        Object obj0 = this.obj;
        if (obj0 == null) {
            obj0 = this.deserializeValue(null);
        }
        return (T)obj0;
    }

    @Override
    public BinaryObject clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int hashCode() {
        return BinaryPrimitives.readInt(this.arr, this.start + 8);
    }

    @Override
    public boolean hasSchema() {
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        return BinaryUtils.hasSchema(flags);
    }

    @Override
    public int schemaId() {
        return BinaryPrimitives.readInt(this.arr, this.start + 16);
    }

    @Override
    public BinarySchema createSchema() {
        return this.reader(null, false).getOrCreateSchema();
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.detachAllowed) {
            int len = this.length();
            out.writeInt(len);
            out.write(this.arr, this.start, len);
            out.writeInt(0);
        } else {
            out.writeInt(this.arr.length);
            out.write(this.arr);
            out.writeInt(this.start);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ctx = GridBinaryMarshaller.threadLocalContext();
        this.arr = new byte[in.readInt()];
        in.readFully(this.arr);
        this.start = in.readInt();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("arr", this.arr, this.detachAllowed ? (long)this.start : 0L, this.detachAllowed ? this.length() : this.arr.length)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeInt("part", this.part)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeInt("start", this.detachAllowed ? 0 : this.start)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.arr = reader.readByteArray("arr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.part = reader.readInt("part");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.start = reader.readInt("start");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(BinaryObjectImpl.class);
    }

    @Override
    public short directType() {
        return 113;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    private Object deserializeValue(@Nullable CacheObjectValueContext coCtx) {
        BinaryReaderExImpl reader = this.reader(null, coCtx != null ? coCtx.kernalContext().config().getClassLoader() : this.ctx.configuration().getClassLoader(), true);
        Object obj0 = reader.deserialize();
        BinaryClassDescriptor desc = reader.descriptor();
        assert (desc != null);
        if (coCtx != null && coCtx.storeValue()) {
            this.obj = obj0;
        }
        return obj0;
    }

    private boolean needCopy(CacheObjectValueContext ctx) {
        return ctx.copyOnGet() && this.obj != null && !ctx.kernalContext().cacheObjects().immutable(this.obj);
    }

    private BinaryReaderExImpl reader(@Nullable BinaryReaderHandles rCtx, @Nullable ClassLoader ldr, boolean forUnmarshal) {
        if (ldr == null) {
            ldr = this.ctx.configuration().getClassLoader();
        }
        return new BinaryReaderExImpl(this.ctx, BinaryHeapInputStream.create(this.arr, this.start), ldr, rCtx, false, forUnmarshal);
    }

    private BinaryReaderExImpl reader(@Nullable BinaryReaderHandles rCtx, boolean forUnmarshal) {
        return this.reader(rCtx, null, forUnmarshal);
    }

    public static int compareForDml(Object first, Object second) {
        boolean firstBinary = first instanceof BinaryObjectImpl;
        boolean secondBinary = second instanceof BinaryObjectImpl;
        if (firstBinary) {
            if (secondBinary) {
                return BinaryObjectImpl.compareForDml0((BinaryObjectImpl)first, (BinaryObjectImpl)second);
            }
            return 1;
        }
        if (secondBinary) {
            return -1;
        }
        return ((Comparable)first).compareTo(second);
    }

    private static int compareForDml0(BinaryObjectImpl first, BinaryObjectImpl second) {
        int res = Integer.compare(first.typeId(), second.typeId());
        if (res == 0 && (res = Integer.compare(first.hashCode(), second.hashCode())) == 0) {
            int secondLen;
            int firstDataStart = first.dataStartOffset();
            int secondDataStart = second.dataStartOffset();
            int firstLen = first.footerStartOffset() - firstDataStart;
            res = Integer.compare(firstLen, secondLen = second.footerStartOffset() - secondDataStart);
            if (res == 0) {
                byte secondByte;
                byte firstByte;
                for (int i = 0; i < firstLen && (res = Byte.compare(firstByte = first.arr[firstDataStart + i], secondByte = second.arr[secondDataStart + i])) == 0; ++i) {
                }
            }
        }
        return res;
    }

    @Override
    public int size() {
        return this.length();
    }

    @Override
    public String toString() {
        if (this.arr == null || this.ctx == null) {
            return "BinaryObjectImpl [arr= " + (this.arr != null) + ", ctx=" + (this.ctx != null) + ", start=" + this.start + "]";
        }
        return super.toString();
    }
}

