/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.util.JDK;
import org.terracotta.angela.common.util.JavaLocationResolver;

public class TerracottaCommandLineEnvironment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TerracottaCommandLineEnvironment.class);
    public static final TerracottaCommandLineEnvironment DEFAULT;
    private final boolean useJavaHome;
    private final String javaVersion;
    private final Set<String> javaVendors;
    private final Set<String> javaOpts;

    private TerracottaCommandLineEnvironment(boolean useJavaHome, String javaVersion, Set<String> javaVendors, Set<String> javaOpts) {
        TerracottaCommandLineEnvironment.validate(useJavaHome, javaVersion, javaVendors, javaOpts);
        this.useJavaHome = useJavaHome;
        this.javaVersion = javaVersion;
        this.javaVendors = Collections.unmodifiableSet(new LinkedHashSet<String>(javaVendors));
        this.javaOpts = Collections.unmodifiableSet(new LinkedHashSet<String>(javaOpts));
    }

    private static void validate(boolean useJavaHome, String javaVersion, Set<String> javaVendors, Set<String> javaOpts) {
        Objects.requireNonNull(javaVendors);
        Objects.requireNonNull(javaOpts);
        if (javaOpts.stream().anyMatch(opt -> opt == null || opt.isEmpty())) {
            throw new IllegalArgumentException("None of the java opts can be null or empty");
        }
        if (useJavaHome) {
            if (javaVersion != null) {
                throw new IllegalArgumentException("Java version must be null in user mode");
            }
            if (!javaVendors.isEmpty()) {
                throw new IllegalArgumentException("Java vendors must be empty in user mode");
            }
        } else {
            if (javaVersion == null || javaVersion.trim().isEmpty()) {
                throw new IllegalArgumentException("Java version must be set");
            }
            if (javaVendors.isEmpty()) {
                throw new IllegalArgumentException("Java vendor required");
            }
            if (javaVendors.stream().anyMatch(vendor -> vendor == null || vendor.trim().isEmpty())) {
                throw new IllegalArgumentException("None of the java vendor can be null or empty");
            }
        }
    }

    public boolean isToolchainBased() {
        return !this.useJavaHome;
    }

    public TerracottaCommandLineEnvironment withJavaVersion(String javaVersion) {
        return this.useJavaHome ? this.withJava(javaVersion, AngelaProperties.JAVA_VENDOR.getDefaultValue()) : this.withJava(javaVersion, this.javaVendors.toArray(new String[0]));
    }

    public TerracottaCommandLineEnvironment withJavaVendors(String ... javaVendors) {
        return this.useJavaHome ? this.withJava(AngelaProperties.JAVA_VERSION.getDefaultValue(), javaVendors) : this.withJava(this.javaVersion, javaVendors);
    }

    public TerracottaCommandLineEnvironment withJava(String javaVersion, String ... javaVendors) {
        return new TerracottaCommandLineEnvironment(false, javaVersion, new LinkedHashSet<String>(Arrays.asList(javaVendors)), this.javaOpts);
    }

    public TerracottaCommandLineEnvironment withJavaOpts(String ... javaOpts) {
        return new TerracottaCommandLineEnvironment(this.useJavaHome, this.javaVersion, this.javaVendors, new LinkedHashSet<String>(Arrays.asList(javaOpts)));
    }

    public TerracottaCommandLineEnvironment withCurrentJavaHome() {
        return new TerracottaCommandLineEnvironment(true, null, Collections.emptySet(), this.javaOpts);
    }

    public Path getJavaHome() {
        if (this.useJavaHome) {
            return Paths.get(AngelaProperties.JAVA_HOME.getValue(), new String[0]);
        }
        List<JDK> jdks = new JavaLocationResolver().resolveJavaLocations(this.getJavaVersion(), this.getJavaVendors(), true);
        if (jdks.size() > 1) {
            LOGGER.warn("Multiple matching java versions found: {} - using the 1st one", (Object)jdks);
        }
        return Paths.get(jdks.get(0).getHome(), new String[0]);
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public Set<String> getJavaVendors() {
        return this.javaVendors;
    }

    public Set<String> getJavaOpts() {
        return this.javaOpts;
    }

    public Map<String, String> buildEnv(Map<String, String> overrides) {
        LOGGER.debug("overrides={}", (Object)overrides);
        HashMap<String, String> env = new HashMap<String, String>();
        Path javaHome = this.getJavaHome();
        env.put("JAVA_HOME", javaHome.toString());
        Set<String> javaOpts = this.getJavaOpts();
        if (!javaOpts.isEmpty()) {
            String joinedJavaOpts = String.join((CharSequence)" ", javaOpts);
            env.put("JAVA_OPTS", joinedJavaOpts);
        }
        for (Map.Entry<String, String> entry : overrides.entrySet()) {
            if (entry.getValue() == null) {
                env.remove(entry.getKey());
                continue;
            }
            env.put(entry.getKey(), entry.getValue());
        }
        Stream.of("JAVA_HOME", "JAVA_OPTS").forEach(key -> LOGGER.debug(" {} = {}", key, env.get(key)));
        return env;
    }

    public String toString() {
        return "TerracottaCommandLineEnvironment{javaVersion='" + this.javaVersion + '\'' + ", javaVendors=" + this.javaVendors + ", javaOpts=" + this.javaOpts + '}';
    }

    static {
        LinkedHashSet<String> opts = AngelaProperties.JAVA_OPTS.getValue().equals("") ? new LinkedHashSet<String>() : new LinkedHashSet<String>(Arrays.asList(AngelaProperties.JAVA_OPTS.getValue().split("\\s")));
        opts.removeIf(s -> s.trim().isEmpty());
        switch (AngelaProperties.JAVA_RESOLVER.getValue()) {
            case "toolchain": {
                String version = AngelaProperties.JAVA_VERSION.getValue();
                LinkedHashSet<String> vendors = AngelaProperties.JAVA_VENDOR.getValue() == null ? Collections.emptySet() : new LinkedHashSet<String>(Arrays.asList(AngelaProperties.JAVA_VENDOR.getValue().split("[,\\s]")));
                DEFAULT = new TerracottaCommandLineEnvironment(false, version, vendors, opts);
                break;
            }
            case "user": {
                DEFAULT = new TerracottaCommandLineEnvironment(true, null, Collections.emptySet(), opts);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported value for '" + AngelaProperties.JAVA_RESOLVER.getPropertyName() + "': " + AngelaProperties.JAVA_RESOLVER.getValue()));
            }
        }
    }
}

