/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.com;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgnitePredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.com.AgentGroup;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.common.util.AngelaVersion;

public class IgniteAgentGroup
extends AgentGroup {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(IgniteAgentGroup.class);
    private final transient Ignite ignite;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private final transient Map<AgentID, CompletableFuture<Void>> shutdowns = new LinkedHashMap<AgentID, CompletableFuture<Void>>();
    private final Map<AgentID, Meta> discoveredAgents = new LinkedHashMap<AgentID, Meta>();

    IgniteAgentGroup(UUID id, AgentID me, Ignite ignite) {
        super(id, me);
        this.ignite = ignite;
        this.joined(me, null);
        ignite.events(ignite.cluster().forAttribute("angela.group", this.getId().toString())).remoteListen(new IgniteBiPredicate<UUID, Event>(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean apply(UUID uuid, Event event) {
                try {
                    switch (event.type()) {
                        case 10: {
                            IgniteAgentGroup.this.joined(AgentID.valueOf((String)((DiscoveryEvent)event).eventNode().attribute("angela.nodeName")), null);
                            break;
                        }
                        case 11: {
                            IgniteAgentGroup.this.left(AgentID.valueOf((String)((DiscoveryEvent)event).eventNode().attribute("angela.nodeName")));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Event: {} error: {}", event, e.getMessage(), e);
                }
                return true;
            }
        }, new IgnitePredicate<Event>(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean apply(Event event) {
                return true;
            }
        }, 11, 10);
    }

    @Override
    public Collection<AgentID> getAllAgents() {
        return this.discoveredAgents.keySet();
    }

    void joined(AgentID agentID, String hostname) {
        Objects.requireNonNull(agentID);
        Meta meta = this.discoveredAgents.computeIfAbsent(agentID, key -> {
            Map attrs = this.clusterGroup(agentID).map(clusterGroup -> clusterGroup.node().attributes().entrySet().stream().filter(e -> e.getValue() instanceof String).sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue()), (s, s2) -> {
                throw new UnsupportedOperationException();
            }, LinkedHashMap::new))).orElse(null);
            if (attrs == null) {
                return null;
            }
            if (!attrs.containsKey("angela.group") || !Objects.equals(attrs.get("angela.group"), this.getId().toString())) {
                throw new IllegalStateException("Agent: " + agentID + " in group: " + (String)attrs.get("angela.group") + " is not part of group: " + this.getId());
            }
            if (!attrs.containsKey("angela.version") || !Objects.equals(attrs.get("angela.version"), AngelaVersion.getAngelaVersion())) {
                throw new IllegalStateException("Agent: " + agentID + " is running version [" + (String)attrs.get("angela.version") + "] but the expected version is [" + AngelaVersion.getAngelaVersion() + "]");
            }
            logger.info("Agent: {} has joined cluster group: {}", (Object)agentID, (Object)this.getId());
            return new Meta(attrs, hostname);
        });
        if (meta != null && hostname != null && !meta.hostnames.contains(hostname)) {
            AgentID existing = this.findRemoteAgentID(hostname).orElse(null);
            if (existing != null && !Objects.equals(agentID, existing)) {
                throw new IllegalStateException("Two agents are serving the same hostname: " + hostname + ": already registered: " + existing + ", new one: " + agentID);
            }
            meta.hostnames.add(hostname);
        }
    }

    private void left(AgentID agentID) {
        Meta meta = this.discoveredAgents.remove(agentID);
        if (meta != null) {
            meta.hostnames.clear();
            this.getShutdown(agentID).complete(null);
            logger.info("Agent: {} has left cluster group: {}", (Object)agentID, (Object)this.getId());
        }
    }

    Optional<AgentID> findRemoteAgentID(String hostname) {
        AgentID localAgentID = this.getLocalAgentID();
        Meta meta = this.discoveredAgents.get(localAgentID);
        if (meta != null && meta.hostnames.contains(hostname)) {
            return Optional.of(localAgentID);
        }
        AgentID agentID = this.discoveredAgents.entrySet().stream().filter(e -> !((AgentID)e.getKey()).isLocal()).filter(e -> ((AgentID)e.getKey()).getName().equals("remote-agent")).filter(e -> ((Meta)e.getValue()).hostnames.contains(hostname)).map(Map.Entry::getKey).findFirst().orElse(null);
        if (agentID != null) {
            return Optional.of(agentID);
        }
        return Optional.empty();
    }

    Optional<ClusterGroup> clusterGroup(AgentID agentID) {
        ClusterGroup clusterGroup = this.ignite.cluster().forAttribute("angela.group", this.getId().toString()).forAttribute("angela.nodeName", agentID.toString());
        if (clusterGroup.nodes().isEmpty()) {
            return Optional.empty();
        }
        if (clusterGroup.nodes().size() > 1) {
            throw new IllegalStateException("Several agents found matching: " + agentID + " in group " + this.getId());
        }
        return Optional.of(clusterGroup);
    }

    Optional<CompletableFuture<Void>> requestShutdown(AgentID agentID) {
        Meta meta = this.discoveredAgents.get(agentID);
        if (meta == null) {
            return Optional.empty();
        }
        if (!this.getSpawnedAgents().contains(agentID)) {
            throw new IllegalArgumentException("Cannot kill inline or local agent: " + agentID);
        }
        ClusterGroup clusterGroup = this.clusterGroup(agentID).orElse(null);
        if (clusterGroup != null) {
            try {
                this.ignite.message(clusterGroup).send((Object)"SYSTEM", "close");
                logger.info("Requested shutdown of agent: {}", (Object)agentID);
            }
            catch (ClusterTopologyException e) {
                this.left(agentID);
            }
        } else {
            this.left(agentID);
        }
        return Optional.of(this.getShutdown(agentID));
    }

    private CompletableFuture<Void> getShutdown(AgentID agentID) {
        return this.shutdowns.computeIfAbsent(agentID, agentID1 -> new CompletableFuture());
    }

    private static class Meta
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Map<String, String> attrs;
        final Collection<String> hostnames = new ConcurrentLinkedQueue<String>();

        Meta(Map<String, String> attrs, String hostname) {
            this.attrs = Objects.requireNonNull(attrs);
            if (hostname != null) {
                this.hostnames.add(hostname);
            }
        }
    }
}

