/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.terracotta.angela.common.util.TimeBudget;

public class RetryUtils {
    public static boolean waitFor(Callable<Boolean> condition, long maxWaitTimeMillis) {
        return RetryUtils.waitFor(condition, maxWaitTimeMillis, TimeUnit.MILLISECONDS);
    }

    public static boolean waitFor(Callable<Boolean> condition, long maxWaitDuration, TimeUnit timeUnit) {
        TimeBudget timeBudget = new TimeBudget(maxWaitDuration, timeUnit);
        boolean success = false;
        do {
            try {
                success = condition.call();
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
        } while (!success && !Thread.currentThread().isInterrupted() && !timeBudget.isDepleted());
        return success;
    }
}

