/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.tcp;

import java.net.InetSocketAddress;
import org.netcrusher.core.filter.TransformFilterFactory;
import org.netcrusher.core.reactor.NioReactor;
import org.netcrusher.core.throttle.ThrottlerFactory;
import org.netcrusher.tcp.TcpCrusher;
import org.netcrusher.tcp.TcpCrusherOptions;
import org.netcrusher.tcp.callback.TcpClientCreation;
import org.netcrusher.tcp.callback.TcpClientDeletion;

public final class TcpCrusherBuilder {
    private final TcpCrusherOptions options = new TcpCrusherOptions();

    private TcpCrusherBuilder() {
    }

    public static TcpCrusherBuilder builder() {
        return new TcpCrusherBuilder();
    }

    public TcpCrusherBuilder withBindAddress(InetSocketAddress address) {
        this.options.setBindAddress(address);
        return this;
    }

    public TcpCrusherBuilder withBindAddress(String hostname, int port) {
        return this.withBindAddress(new InetSocketAddress(hostname, port));
    }

    public TcpCrusherBuilder withConnectAddress(InetSocketAddress address) {
        this.options.setConnectAddress(address);
        return this;
    }

    public TcpCrusherBuilder withConnectAddress(String hostname, int port) {
        return this.withConnectAddress(new InetSocketAddress(hostname, port));
    }

    public TcpCrusherBuilder withBindBeforeConnectAddress(InetSocketAddress address) {
        this.options.setBindBeforeConnectAddress(address);
        return this;
    }

    public TcpCrusherBuilder withBindBeforeConnectAddress(String hostname, int port) {
        return this.withBindBeforeConnectAddress(new InetSocketAddress(hostname, port));
    }

    public TcpCrusherBuilder withReactor(NioReactor reactor) {
        this.options.setReactor(reactor);
        return this;
    }

    public TcpCrusherBuilder withCreationListener(TcpClientCreation creationListener) {
        this.options.setCreationListener(creationListener);
        return this;
    }

    public TcpCrusherBuilder withDeletionListener(TcpClientDeletion deletionListener) {
        this.options.setDeletionListener(deletionListener);
        return this;
    }

    public TcpCrusherBuilder withBacklog(int backlog) {
        this.options.getSocketOptions().setBacklog(backlog);
        return this;
    }

    public TcpCrusherBuilder withKeepAlive(boolean keepAlive) {
        this.options.getSocketOptions().setKeepAlive(keepAlive);
        return this;
    }

    public TcpCrusherBuilder withTcpNoDelay(boolean tcpNoDelay) {
        this.options.getSocketOptions().setTcpNoDelay(tcpNoDelay);
        return this;
    }

    public TcpCrusherBuilder withRcvBufferSize(int bufferSize) {
        this.options.getSocketOptions().setRcvBufferSize(bufferSize);
        return this;
    }

    public TcpCrusherBuilder withSndBufferSize(int bufferSize) {
        this.options.getSocketOptions().setSndBufferSize(bufferSize);
        return this;
    }

    public TcpCrusherBuilder withLingerMs(int timeoutMs) {
        this.options.getSocketOptions().setLingerMs(timeoutMs);
        return this;
    }

    public TcpCrusherBuilder withConnectionTimeoutMs(long timeoutMs) {
        this.options.getSocketOptions().setConnectionTimeoutMs(timeoutMs);
        return this;
    }

    public TcpCrusherBuilder withBufferCount(int bufferCount) {
        this.options.getBufferOptions().setCount(bufferCount);
        return this;
    }

    public TcpCrusherBuilder withBufferSize(int bufferSize) {
        this.options.getBufferOptions().setSize(bufferSize);
        return this;
    }

    public TcpCrusherBuilder withBufferDirect(boolean direct) {
        this.options.getBufferOptions().setDirect(direct);
        return this;
    }

    public TcpCrusherBuilder withOutgoingTransformFilterFactory(TransformFilterFactory filterFactory) {
        this.options.setOutgoingTransformFilterFactory(filterFactory);
        return this;
    }

    public TcpCrusherBuilder withIncomingTransformFilterFactory(TransformFilterFactory filterFactory) {
        this.options.setIncomingTransformFilterFactory(filterFactory);
        return this;
    }

    public TcpCrusherBuilder withOutgoingThrottlerFactory(ThrottlerFactory throttlerFactory) {
        this.options.setOutgoingThrottlerFactory(throttlerFactory);
        return this;
    }

    public TcpCrusherBuilder withIncomingThrottlerFactory(ThrottlerFactory throttlerFactory) {
        this.options.setIncomingThrottlerFactory(throttlerFactory);
        return this;
    }

    public TcpCrusherBuilder withDeferredListeners(boolean deferredListeners) {
        this.options.setDeferredListeners(deferredListeners);
        return this;
    }

    public TcpCrusher build() {
        return new TcpCrusher(this.options);
    }

    public TcpCrusher buildAndOpen() {
        TcpCrusher crusher = this.build();
        crusher.open();
        return crusher;
    }
}

