/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.verify.ValidateIndexesCheckSizeIssue;

public class ValidateIndexesCheckSizeResult
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private long cacheSize;
    @GridToStringExclude
    private Collection<ValidateIndexesCheckSizeIssue> issues;

    public ValidateIndexesCheckSizeResult() {
    }

    public ValidateIndexesCheckSizeResult(long cacheSize, Collection<ValidateIndexesCheckSizeIssue> issues) {
        this.cacheSize = cacheSize;
        this.issues = issues;
    }

    public Collection<ValidateIndexesCheckSizeIssue> issues() {
        return this.issues == null ? Collections.emptyList() : this.issues;
    }

    public long cacheSize() {
        return this.cacheSize;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeLong(this.cacheSize);
        IgniteUtils.writeCollection(out, this.issues);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.cacheSize = in.readLong();
        this.issues = IgniteUtils.readCollection(in);
    }

    public String toString() {
        return S.toString(ValidateIndexesCheckSizeResult.class, this);
    }
}

