/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.AbstractTimeIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKeyFactory;
import org.apache.ignite.internal.pagemem.PageUtils;

public class TimeInlineIndexKeyType
extends NullableInlineIndexKeyType<AbstractTimeIndexKey> {
    public TimeInlineIndexKeyType() {
        super(9, (short)8);
    }

    @Override
    public int compare0(long pageAddr, int off, AbstractTimeIndexKey key) {
        long val1 = PageUtils.getLong(pageAddr, off + 1);
        long val2 = key.nanos();
        return Integer.signum(Long.compare(val1, val2));
    }

    @Override
    protected int put0(long pageAddr, int off, AbstractTimeIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type());
        PageUtils.putLong(pageAddr, off + 1, key.nanos());
        return this.keySize + 1;
    }

    @Override
    protected AbstractTimeIndexKey get0(long pageAddr, int off) {
        long nanos = PageUtils.getLong(pageAddr, off + 1);
        return (AbstractTimeIndexKey)IndexKeyFactory.wrapDateValue(this.type(), 0L, nanos);
    }

    @Override
    protected int inlineSize0(AbstractTimeIndexKey key) {
        return this.keySize + 1;
    }
}

