/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.startup.cmdline;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cdc.CdcConfiguration;
import org.apache.ignite.cdc.CdcLoader;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.cdc.CdcMain;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.startup.cmdline.CommandLineStartup;
import org.jetbrains.annotations.Nullable;

public class CdcCommandLineStartup {
    private static final boolean QUITE = IgniteSystemProperties.getBoolean("IGNITE_QUIET");

    public static void main(String[] args) {
        if (!QUITE) {
            X.println("    __________  ________________    ________  _____" + IgniteKernal.NL + "   /  _/ ___/ |/ /  _/_  __/ __/   / ___/ _ \\/ ___/" + IgniteKernal.NL + "  _/ // (7 7    // /  / / / _/    / /__/ // / /__  " + IgniteKernal.NL + " /___/\\___/_/|_/___/ /_/ /___/    \\___/____/\\___/", new Object[0]);
            X.println("Ignite Change Data Capture Command Line Startup, ver. " + IgniteVersionUtils.ACK_VER_STR, new Object[0]);
            X.println(IgniteVersionUtils.COPYRIGHT, new Object[0]);
            X.println();
        }
        if (args.length > 1) {
            CdcCommandLineStartup.exit("Too many arguments.", true, -1);
        }
        if (args.length > 0 && CommandLineStartup.isHelp(args[0])) {
            CdcCommandLineStartup.exit(null, true, 0);
        }
        if (args.length > 0 && args[0].isEmpty()) {
            CdcCommandLineStartup.exit("Empty argument.", true, 1);
        }
        if (args.length > 0 && args[0].charAt(0) == '-') {
            CdcCommandLineStartup.exit("Invalid arguments: " + args[0], true, -1);
        }
        final AtomicReference<CdcMain> cdc = new AtomicReference<CdcMain>();
        try {
            cdc.set(CdcLoader.loadCdc(args[0]));
            if (!IgniteSystemProperties.getBoolean("IGNITE_NO_SHUTDOWN_HOOK", false)) {
                Runtime.getRuntime().addShutdownHook(new Thread("cdc-shutdown-hook"){

                    @Override
                    public void run() {
                        ((CdcMain)cdc.get()).stop();
                    }
                });
            }
            Thread appThread = new Thread((Runnable)cdc.get());
            appThread.start();
            appThread.join();
        }
        catch (InterruptedException e) {
            if (cdc.get() != null) {
                ((CdcMain)cdc.get()).stop();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            String note = "";
            if (X.hasCause(e, ClassNotFoundException.class)) {
                note = "\nNote! You may use 'USER_LIBS' environment variable to specify your classpath.";
            }
            CdcCommandLineStartup.exit("Failed to run CDC: " + e.getMessage() + note, false, -1);
        }
    }

    private static CdcConfiguration consumerConfig(URL cfgUrl, IgniteSpringHelper spring) throws IgniteCheckedException {
        Map<Class<?>, Object> cdcCfgs = spring.loadBeans(cfgUrl, CdcConfiguration.class);
        if (cdcCfgs == null || cdcCfgs.size() != 1) {
            CdcCommandLineStartup.exit("Exact 1 CaptureDataChangeConfiguration configuration should be defined", false, 1);
        }
        return (CdcConfiguration)cdcCfgs.values().iterator().next();
    }

    private static void exit(@Nullable String errMsg, boolean showUsage, int exitCode) {
        if (errMsg != null) {
            X.error(errMsg, new Object[0]);
        }
        if (showUsage) {
            X.error("Usage:", "    ignite-cdc.{sh|bat} [?]|[path]", "    Where:", "    ?, /help, -help, - show this message.", "    -v               - verbose mode (quiet by default).", "    path            - path to Spring XML configuration file.", "                      Path can be absolute or relative to IGNITE_HOME.", " ", "Spring file should contain bean definition of 'org.apache.ignite.configuration.IgniteConfiguration' And one or more implementations of 'org.apache.ignite.cdc.CDCConsumer'.Note that bean will be fetched by the type and its ID is not used.");
        }
        System.exit(exitCode);
    }
}

