/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class GridDebug {
    private static final AtomicReference<ConcurrentLinkedQueue<Item>> que = new AtomicReference(new ConcurrentLinkedQueue());
    private static final FileOutputStream out;
    private static volatile long start;
    private static final String LOGS_PATH;
    private static boolean allowLog;
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile HotSpotDiagnosticMXBean hotspotMBean;
    private static final String OS_BEAN_NAME = "java.lang:type=OperatingSystem";
    private static volatile OperatingSystemMXBean osMBean;

    public static ConcurrentLinkedQueue<Item> queue() {
        return que.get();
    }

    public static synchronized void allowWriteLog(boolean allow) {
        allowLog = allow;
    }

    public static synchronized void write(Object ... x) {
        if (!allowLog) {
            return;
        }
        Thread th = Thread.currentThread();
        try {
            out.write((GridDebug.formatEntry(System.currentTimeMillis(), th.getName(), th.getId(), x) + "\n").getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void debug(Object ... x) {
        ConcurrentLinkedQueue<Item> q = que.get();
        if (q != null) {
            q.add(new Item(x));
        }
    }

    public static void hangIfStopped() {
        if (que.get() == null) {
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void start() {
        start = U.currentTimeMillis();
    }

    public static void timing(String label) {
        X.println(label + ' ' + (U.currentTimeMillis() - start) + " ms", new Object[0]);
    }

    public static Object dumpStack() {
        final Throwable t = new Throwable();
        return new Object(){

            public String toString() {
                StringWriter errors = new StringWriter();
                t.printStackTrace(new PrintWriter(errors));
                return errors.toString();
            }
        };
    }

    public static void dumpLastAndStop(int n) {
        ConcurrentLinkedQueue q = que.getAndSet(null);
        if (q == null) {
            return;
        }
        int size = q.size();
        while (size-- > n) {
            q.poll();
        }
        GridDebug.dump(q);
    }

    public static void dump(Collection<Item> que) {
        if (que == null) {
            return;
        }
        int start = -1;
        int x = 0;
        for (Item i : que) {
            if (x++ <= start) continue;
            System.out.println(i);
        }
    }

    public static String dumpWithStop(Object ... x) {
        GridDebug.debug(x);
        return GridDebug.dumpWithReset(null, null);
    }

    public static String dumpWithReset() {
        return GridDebug.dumpWithReset(new ConcurrentLinkedQueue<Item>(), null);
    }

    public static String dumpWithReset(@Nullable ConcurrentLinkedQueue<Item> q2, @Nullable IgnitePredicate<Item> filter) {
        ConcurrentLinkedQueue<Item> q;
        while ((q = que.get()) != null && !que.compareAndSet(q, q2)) {
        }
        AbstractCollection col = null;
        if (filter == null) {
            col = q;
        } else if (q != null) {
            col = new ArrayList();
            for (Item item : q) {
                if (!filter.apply(item)) continue;
                col.add((Item)item);
            }
        }
        GridDebug.dump(col);
        return "";
    }

    public static void reset() {
        ConcurrentLinkedQueue<Item> old = que.get();
        if (old != null) {
            que.compareAndSet(old, new ConcurrentLinkedQueue());
        }
    }

    private static String formatEntry(long ts, String threadName, long threadId, Object ... data) {
        return "<" + IgniteUtils.DEBUG_DATE_FMT.format(Instant.ofEpochMilli(ts)) + "><~DBG~><" + threadName + " id:" + threadId + "> " + Arrays.deepToString(data);
    }

    public static void dumpHeap(String fileName, boolean live) {
        GridDebug.initHotspotMBean();
        File f = new File(fileName);
        if (f.exists()) {
            f.delete();
        }
        try {
            hotspotMBean.dumpHeap(fileName, live);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    public static long getCommittedVirtualMemorySize() {
        GridDebug.initOSMBean();
        return osMBean.getCommittedVirtualMemorySize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotspotMBean() {
        if (hotspotMBean != null) return;
        Class<GridDebug> clazz = GridDebug.class;
        synchronized (GridDebug.class) {
            if (hotspotMBean != null) return;
            hotspotMBean = GridDebug.getMBean(HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initOSMBean() {
        if (osMBean != null) return;
        Class<GridDebug> clazz = GridDebug.class;
        synchronized (GridDebug.class) {
            if (osMBean != null) return;
            osMBean = GridDebug.getMBean(OS_BEAN_NAME, OperatingSystemMXBean.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static <T> T getMBean(String mxbeanName, Class<T> mxbeanItf) {
        try {
            MBeanServer srv = ManagementFactory.getPlatformMBeanServer();
            return ManagementFactory.newPlatformMXBeanProxy(srv, mxbeanName, mxbeanItf);
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    static {
        LOGS_PATH = null;
        if (LOGS_PATH != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss-").withZone(ZoneId.systemDefault());
            File log = new File(new File(LOGS_PATH), formatter.format(Instant.now()) + ManagementFactory.getRuntimeMXBean().getName() + ".log");
            assert (!log.exists());
            try {
                out = new FileOutputStream(log, false);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(e);
            }
        } else {
            out = null;
        }
    }

    public static class Item {
        public final long ts = System.currentTimeMillis();
        public final String threadName;
        public final long threadId;
        public final Object[] data;

        public Item(Object[] data) {
            this.data = data;
            Thread th = Thread.currentThread();
            this.threadName = th.getName();
            this.threadId = th.getId();
        }

        public String toString() {
            return GridDebug.formatEntry(this.ts, this.threadName, this.threadId, this.data);
        }
    }
}

