/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.vm;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinderAdapter;

public class TcpDiscoveryVmIpFinder
extends TcpDiscoveryIpFinderAdapter {
    @LoggerResource
    private IgniteLogger log;
    @GridToStringInclude
    private Collection<String> addrs = new ArrayList<String>();
    @GridToStringInclude
    private Collection<InetSocketAddress> registeredAddrs = new LinkedHashSet<InetSocketAddress>();

    public TcpDiscoveryVmIpFinder() {
        String ips = IgniteSystemProperties.getString("IGNITE_TCP_DISCOVERY_ADDRESSES");
        if (!F.isEmpty(ips)) {
            for (String s : ips.split(",")) {
                if (F.isEmpty(s) || F.isEmpty(s = s.trim())) continue;
                try {
                    this.addrs.add(s);
                }
                catch (IgniteSpiException e) {
                    throw new IgniteException(e);
                }
            }
        }
    }

    public TcpDiscoveryVmIpFinder(boolean shared) {
        String ips = IgniteSystemProperties.getString("IGNITE_TCP_DISCOVERY_ADDRESSES");
        if (!F.isEmpty(ips)) {
            for (String s : ips.split(",")) {
                if (F.isEmpty(s) || F.isEmpty(s = s.trim())) continue;
                try {
                    this.addrs.add(s);
                }
                catch (IgniteSpiException e) {
                    throw new IgniteException(e);
                }
            }
        }
        this.setShared(shared);
    }

    @IgniteSpiConfiguration(optional=true)
    public synchronized TcpDiscoveryVmIpFinder setAddresses(Collection<String> addrs) throws IgniteSpiException {
        if (F.isEmpty(addrs)) {
            return this;
        }
        for (String ipStr : addrs) {
            TcpDiscoveryVmIpFinder.address(ipStr);
        }
        this.addrs = new ArrayList<String>(addrs);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Collection<InetSocketAddress> address(String ipStr) throws IgniteSpiException {
        ipStr = ipStr.trim();
        String errMsg = "Failed to parse provided address: " + ipStr;
        int colonCnt = ipStr.length() - ipStr.replace(":", "").length();
        if (colonCnt > 1) {
            if (ipStr.startsWith("[")) {
                if ((ipStr = ipStr.substring(1)).contains("]:")) {
                    return TcpDiscoveryVmIpFinder.addresses(ipStr, "\\]\\:", errMsg);
                }
                if (!ipStr.endsWith("]")) throw new IgniteSpiException(errMsg);
                ipStr = ipStr.substring(0, ipStr.length() - 1);
            }
        } else if (ipStr.endsWith(":")) {
            ipStr = ipStr.substring(0, ipStr.length() - 1);
        } else if (ipStr.indexOf(58) >= 0) {
            return TcpDiscoveryVmIpFinder.addresses(ipStr, "\\:", errMsg);
        }
        LinkedHashSet<InetSocketAddress> col = new LinkedHashSet();
        try {
            InetAddress[] inetAddresses;
            InetAddress[] inetAddressArray = inetAddresses = InetAddress.getAllByName(ipStr);
            int n = inetAddressArray.length;
            int n2 = 0;
            while (n2 < n) {
                InetAddress addrs = inetAddressArray[n2];
                col.add(new InetSocketAddress(addrs, 0));
                ++n2;
            }
            return col;
        }
        catch (UnknownHostException ignored) {
            return Collections.singleton(new InetSocketAddress(ipStr, 0));
        }
    }

    private static Collection<InetSocketAddress> addresses(String ipStr, String regexDelim, String errMsg) throws IgniteSpiException {
        String[] tokens = ipStr.split(regexDelim);
        if (tokens.length == 2) {
            int port2;
            int port1;
            String addrStr = tokens[0];
            String portStr = tokens[1];
            if (portStr.contains("..")) {
                port1 = Integer.parseInt(portStr.substring(0, portStr.indexOf("..")));
                port2 = Integer.parseInt(portStr.substring(portStr.indexOf("..") + 2, portStr.length()));
            } else {
                port1 = port2 = Integer.parseInt(portStr);
            }
            if (port1 != port2 && port2 < port1 || port1 <= 0 || port2 <= 0) {
                throw new IgniteSpiException(errMsg);
            }
            try {
                InetAddress[] inetAddresses;
                ArrayList<InetSocketAddress> res = new ArrayList<InetSocketAddress>();
                try {
                    inetAddresses = InetAddress.getAllByName(addrStr);
                }
                catch (UnknownHostException e) {
                    for (int i = port1; i <= port2; ++i) {
                        res.add(new InetSocketAddress(addrStr, i));
                    }
                    return res;
                }
                for (InetAddress curAddr : inetAddresses) {
                    for (int i = port1; i <= port2; ++i) {
                        res.add(new InetSocketAddress(curAddr, i));
                    }
                }
                return res;
            }
            catch (IllegalArgumentException e) {
                throw new IgniteSpiException(errMsg, e);
            }
        }
        throw new IgniteSpiException(errMsg);
    }

    @Override
    public synchronized Collection<InetSocketAddress> getRegisteredAddresses() {
        LinkedHashSet<InetSocketAddress> resolvedAddrs = new LinkedHashSet<InetSocketAddress>();
        for (String ipStr : this.addrs) {
            resolvedAddrs.addAll(TcpDiscoveryVmIpFinder.address(ipStr));
        }
        resolvedAddrs.addAll(this.registeredAddrs);
        return resolvedAddrs;
    }

    @Override
    public synchronized void registerAddresses(Collection<InetSocketAddress> addrs) {
        assert (!F.isEmpty(addrs));
        if (!F.isEmpty(addrs)) {
            this.registeredAddrs.addAll(addrs);
        }
    }

    @Override
    public synchronized void unregisterAddresses(Collection<InetSocketAddress> addrs) {
        assert (!F.isEmpty(addrs));
        if (!F.isEmpty(addrs)) {
            this.registeredAddrs.removeAll(addrs);
        }
    }

    @Override
    public TcpDiscoveryVmIpFinder setShared(boolean shared) {
        super.setShared(shared);
        return this;
    }

    @Override
    public String toString() {
        return S.toString(TcpDiscoveryVmIpFinder.class, this, "super", (Object)super.toString());
    }
}

