/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;

public class IpUtils {
    private static final String LOCAL_HOSTNAME;

    public static boolean isLocal(String name) {
        switch (name) {
            case "localhost": 
            case "127.0.0.1": 
            case " ::1": {
                return true;
            }
        }
        return LOCAL_HOSTNAME.equals(name) || name.startsWith("169.254.") || name.startsWith("fe80:");
    }

    public static boolean areAllLocal(Collection<String> targetServerNames) {
        for (String targetServerName : targetServerNames) {
            if (IpUtils.isLocal(targetServerName)) continue;
            return false;
        }
        return true;
    }

    public static String getHostName() {
        return LOCAL_HOSTNAME;
    }

    static {
        try {
            LOCAL_HOSTNAME = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

