/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.clientconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.terracotta.angela.common.clientconfig.ClientSymbolicName;
import org.terracotta.angela.common.util.IpUtils;

public class ClientArrayConfig {
    private final Map<ClientSymbolicName, String> hosts = new HashMap<ClientSymbolicName, String>();

    private ClientArrayConfig() {
    }

    public static ClientArrayConfig newClientArrayConfig() {
        return new ClientArrayConfig();
    }

    public ClientArrayConfig named(String symbolicName) {
        return this.host(symbolicName, IpUtils.getHostName());
    }

    @Deprecated
    public ClientArrayConfig host(String hostname) {
        return this.host(hostname, hostname);
    }

    public ClientArrayConfig host(String clientSymbolicName, String hostname) {
        ClientSymbolicName key = new ClientSymbolicName(clientSymbolicName);
        if (this.hosts.containsKey(key)) {
            throw new IllegalArgumentException("Client with symbolic name '" + clientSymbolicName + "' already present in the client array config");
        }
        this.hosts.put(key, hostname);
        return this;
    }

    public Map<ClientSymbolicName, String> getHosts() {
        return Collections.unmodifiableMap(this.hosts);
    }

    public ClientArrayConfig hostSerie(int serieLength, String hostname) {
        for (int i = 0; i < serieLength; ++i) {
            String clientSymbolicName = hostname + "-" + i;
            this.host(clientSymbolicName, hostname);
        }
        return this;
    }

    public ClientArrayConfig hostSerie(int serieLength) {
        for (int i = 0; i < serieLength; ++i) {
            String clientSymbolicName = IpUtils.getHostName() + "-" + i;
            this.host(clientSymbolicName, IpUtils.getHostName());
        }
        return this;
    }
}

