/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.AngelaProperties;
import org.terracotta.angela.common.util.JDK;
import org.terracotta.angela.common.util.JavaBinaries;
import org.terracotta.angela.common.util.JavaLocationResolver;

public class TerracottaCommandLineEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerracottaCommandLineEnvironment.class);
    public static final TerracottaCommandLineEnvironment DEFAULT;
    private final Path javaHome;
    private final String javaVersion;
    private final Set<String> javaVendors;
    private final Set<String> javaOpts;
    private final JavaLocationResolver javaLocationResolver;

    private TerracottaCommandLineEnvironment(Path javaHome, String javaVersion, Set<String> javaVendors, Set<String> javaOpts) {
        TerracottaCommandLineEnvironment.validate(javaVersion, javaVendors, javaOpts);
        this.javaHome = javaHome;
        this.javaVersion = javaVersion;
        this.javaVendors = Collections.unmodifiableSet(new LinkedHashSet<String>(javaVendors));
        this.javaOpts = Collections.unmodifiableSet(new LinkedHashSet<String>(javaOpts));
        this.javaLocationResolver = javaHome != null ? null : new JavaLocationResolver();
    }

    private TerracottaCommandLineEnvironment(String javaVersion, Set<String> javaVendors, Set<String> javaOpts) {
        this(null, javaVersion, javaVendors, javaOpts);
    }

    private static void validate(String javaVersion, Set<String> javaVendors, Set<String> javaOpts) {
        Objects.requireNonNull(javaVersion);
        Objects.requireNonNull(javaVendors);
        Objects.requireNonNull(javaOpts);
        if (javaVendors.stream().anyMatch(vendor -> vendor == null || vendor.isEmpty())) {
            throw new IllegalArgumentException("None of the java vendors can be null or empty");
        }
        if (javaOpts.stream().anyMatch(opt -> opt == null || opt.isEmpty())) {
            throw new IllegalArgumentException("None of the java opts can be null or empty");
        }
    }

    public TerracottaCommandLineEnvironment withJavaVersion(String javaVersion) {
        if (this.javaHome != null) {
            throw new UnsupportedOperationException("Unable to change the Java version when using the 'user' resolver");
        }
        return new TerracottaCommandLineEnvironment(null, javaVersion, this.javaVendors, this.javaOpts);
    }

    public TerracottaCommandLineEnvironment withJavaVendors(String ... javaVendors) {
        if (this.javaHome != null) {
            throw new UnsupportedOperationException("Unable to change the Java vendors when using the 'user' resolver");
        }
        return new TerracottaCommandLineEnvironment(null, this.javaVersion, new LinkedHashSet<String>(Arrays.asList(javaVendors)), this.javaOpts);
    }

    public TerracottaCommandLineEnvironment withJavaOpts(String ... javaOpts) {
        return new TerracottaCommandLineEnvironment(this.javaHome, this.javaVersion, this.javaVendors, new LinkedHashSet<String>(Arrays.asList(javaOpts)));
    }

    public TerracottaCommandLineEnvironment withCurrentJavaHome() {
        return this.withJavaHome(JavaBinaries.javaHome());
    }

    public TerracottaCommandLineEnvironment withJavaHome(Path jdkHome) {
        return new TerracottaCommandLineEnvironment(Objects.requireNonNull(jdkHome), "", Collections.emptySet(), this.javaOpts);
    }

    public Path getJavaHome() {
        return Optional.ofNullable(this.javaHome).orElseGet(() -> {
            List<JDK> jdks = this.javaLocationResolver.resolveJavaLocations(this.getJavaVersion(), this.getJavaVendors(), true);
            if (jdks.size() > 1) {
                LOGGER.warn("Multiple matching java versions found: {} - using the 1st one", (Object)jdks);
            }
            return jdks.get(0).getHome();
        });
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public Set<String> getJavaVendors() {
        return this.javaVendors;
    }

    public Set<String> getJavaOpts() {
        return this.javaOpts;
    }

    public Map<String, String> buildEnv(Map<String, String> overrides) {
        LOGGER.info("overrides={}", (Object)overrides);
        HashMap<String, String> env = new HashMap<String, String>();
        Path javaHome = this.getJavaHome();
        env.put("JAVA_HOME", javaHome.toString());
        Set<String> javaOpts = this.getJavaOpts();
        if (!javaOpts.isEmpty()) {
            String joinedJavaOpts = String.join((CharSequence)" ", javaOpts);
            env.put("JAVA_OPTS", joinedJavaOpts);
        }
        for (Map.Entry<String, String> entry : overrides.entrySet()) {
            if (entry.getValue() == null) {
                env.remove(entry.getKey());
                continue;
            }
            env.put(entry.getKey(), entry.getValue());
        }
        Stream.of("JAVA_HOME", "JAVA_OPTS").forEach(key -> LOGGER.info(" {} = {}", key, env.get(key)));
        return env;
    }

    public String toString() {
        return "TerracottaCommandLineEnvironment{javaVersion='" + this.javaVersion + '\'' + ", javaVendors=" + this.javaVendors + ", javaOpts=" + this.javaOpts + '}';
    }

    static {
        switch (AngelaProperties.JAVA_RESOLVER.getValue()) {
            case "toolchain": {
                String version = AngelaProperties.JAVA_VERSION.getValue();
                LinkedHashSet<String> vendors = AngelaProperties.JAVA_VENDOR.getValue().equals("") ? new LinkedHashSet() : Collections.singleton(AngelaProperties.JAVA_VENDOR.getValue());
                LinkedHashSet<String> opts = AngelaProperties.JAVA_OPTS.getValue().equals("") ? new LinkedHashSet() : Collections.singleton(AngelaProperties.JAVA_OPTS.getValue());
                DEFAULT = new TerracottaCommandLineEnvironment(version, vendors, opts);
                break;
            }
            case "user": {
                LinkedHashSet<String> opts = AngelaProperties.JAVA_OPTS.getValue().equals("") ? new LinkedHashSet() : Collections.singleton(AngelaProperties.JAVA_OPTS.getValue());
                DEFAULT = new TerracottaCommandLineEnvironment(Paths.get(AngelaProperties.JAVA_HOME.getValue(), new String[0]), "", Collections.emptySet(), opts);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported value for '" + AngelaProperties.JAVA_RESOLVER.getPropertyName() + "': " + AngelaProperties.JAVA_RESOLVER.getValue()));
            }
        }
    }
}

