/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.apache.ignite.internal.managers.encryption.GridEncryptionManager;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.processors.cache.persistence.file.EncryptionUtil;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.spi.encryption.EncryptionSpi;

public class EncryptedFileIO
implements FileIO {
    private final FileIO plainFileIO;
    private final int groupId;
    private final int pageSize;
    private final int headerSize;
    private final GridEncryptionManager encMgr;
    private final EncryptionSpi encSpi;
    private final EncryptionUtil encUtil;

    EncryptedFileIO(FileIO plainFileIO, int groupId, int pageSize, int headerSize, GridEncryptionManager encMgr, EncryptionSpi encSpi) {
        this.plainFileIO = plainFileIO;
        this.groupId = groupId;
        this.pageSize = pageSize;
        this.headerSize = headerSize;
        this.encMgr = encMgr;
        this.encSpi = encSpi;
        this.encUtil = new EncryptionUtil(encSpi, pageSize);
    }

    @Override
    public int getFileSystemBlockSize() {
        return -1;
    }

    @Override
    public long getSparseSize() {
        return -1L;
    }

    @Override
    public int punchHole(long position, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() throws IOException {
        return this.plainFileIO.position();
    }

    @Override
    public void position(long newPosition) throws IOException {
        this.plainFileIO.position(newPosition);
    }

    @Override
    public int read(ByteBuffer destBuf) throws IOException {
        assert (this.position() == 0L);
        return this.plainFileIO.read(destBuf);
    }

    @Override
    public int readFully(ByteBuffer destBuf) throws IOException {
        return this.read(destBuf);
    }

    @Override
    public int read(ByteBuffer destBuf, long position) throws IOException {
        assert (destBuf.remaining() >= this.pageSize);
        assert (this.position() != 0L);
        ByteBuffer encrypted = ByteBuffer.allocate(this.pageSize);
        int res = this.plainFileIO.read(encrypted, position);
        if (res < 0) {
            return res;
        }
        if (res != this.pageSize) {
            throw new IllegalStateException("Expecting to read whole page[" + this.pageSize + " bytes], but read only " + res + " bytes");
        }
        encrypted.rewind();
        this.decrypt(encrypted, destBuf);
        return res;
    }

    @Override
    public int readFully(ByteBuffer destBuf, long position) throws IOException {
        assert (destBuf.capacity() == this.pageSize);
        assert (this.position() != 0L);
        ByteBuffer encrypted = ByteBuffer.allocate(this.pageSize);
        int res = this.plainFileIO.readFully(encrypted, position);
        if (res < 0) {
            return res;
        }
        if (res != this.pageSize) {
            throw new IllegalStateException("Expecting to read whole page[" + this.pageSize + " bytes], but read only " + res + " bytes");
        }
        encrypted.rewind();
        this.decrypt(encrypted, destBuf);
        return res;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException("Encrypted File doesn't support this operation");
    }

    @Override
    public int readFully(byte[] buf, int off, int len) throws IOException {
        return this.read(buf, off, len);
    }

    @Override
    public int write(ByteBuffer srcBuf) throws IOException {
        assert (this.position() == 0L);
        assert (this.headerSize == srcBuf.capacity());
        return this.plainFileIO.write(srcBuf);
    }

    @Override
    public int writeFully(ByteBuffer srcBuf) throws IOException {
        return this.write(srcBuf);
    }

    @Override
    public int write(ByteBuffer srcBuf, long position) throws IOException {
        ByteBuffer encrypted = ByteBuffer.allocate(this.pageSize);
        this.encrypt(srcBuf, encrypted);
        encrypted.rewind();
        return this.plainFileIO.write(encrypted, position);
    }

    @Override
    public int writeFully(ByteBuffer srcBuf, long position) throws IOException {
        ByteBuffer encrypted = ByteBuffer.allocate(this.pageSize);
        this.encrypt(srcBuf, encrypted);
        encrypted.rewind();
        return this.plainFileIO.writeFully(encrypted, position);
    }

    private void encrypt(ByteBuffer srcBuf, ByteBuffer res) throws IOException {
        assert (this.position() != 0L);
        GroupKey grpKey = this.encMgr.getActiveKey(this.groupId);
        this.encUtil.encrypt(srcBuf, res, grpKey);
    }

    private void decrypt(ByteBuffer encrypted, ByteBuffer destBuf) throws IOException {
        int keyId = encrypted.get(this.encryptedDataSize() + 4) & 0xFF;
        GroupKey grpKey = this.encMgr.groupKey(this.groupId, keyId);
        assert (grpKey != null) : keyId;
        this.encUtil.decrypt(encrypted, destBuf, grpKey);
    }

    private int encryptedDataSize() {
        return this.pageSize - this.encSpi.blockSize();
    }

    @Override
    public int write(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException("Encrypted File doesn't support this operation");
    }

    @Override
    public int writeFully(byte[] buf, int off, int len) throws IOException {
        return this.write(buf, off, len);
    }

    @Override
    public MappedByteBuffer map(int sizeBytes) throws IOException {
        throw new UnsupportedOperationException("Encrypted File doesn't support this operation");
    }

    @Override
    public void force() throws IOException {
        this.plainFileIO.force();
    }

    @Override
    public void force(boolean withMetadata) throws IOException {
        this.plainFileIO.force(withMetadata);
    }

    @Override
    public long size() throws IOException {
        return this.plainFileIO.size();
    }

    @Override
    public void clear() throws IOException {
        this.plainFileIO.clear();
    }

    @Override
    public void close() throws IOException {
        this.plainFileIO.close();
    }
}

