/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline;

import java.util.Arrays;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.cache.query.index.IndexName;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyTypeRegistry;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.JavaObjectIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NullIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;

public class InlineObjectBytesDetector
implements BPlusTree.TreeRowClosure<IndexRow, IndexRow> {
    private final int inlineSize;
    private final List<IndexKeyDefinition> keyDefs;
    private boolean inlineObjSupported = true;
    private final IndexName idxName;
    private final IgniteLogger log;

    public InlineObjectBytesDetector(int inlineSize, List<IndexKeyDefinition> keyDefs, IndexName idxName, IgniteLogger log) {
        this.inlineSize = inlineSize;
        this.keyDefs = keyDefs;
        this.idxName = idxName;
        this.log = log;
    }

    @Override
    public boolean apply(BPlusTree<IndexRow, IndexRow> tree, BPlusIO<IndexRow> io, long pageAddr, int idx) throws IgniteCheckedException {
        IndexRow r = tree.getRow(io, pageAddr, idx);
        int off = io.offset(idx);
        int fieldOff = 0;
        boolean varLenPresents = false;
        IndexKeyTypeSettings keyTypeSettings = new IndexKeyTypeSettings();
        for (int i = 0; i < this.keyDefs.size(); ++i) {
            IndexKeyDefinition keyDef = this.keyDefs.get(i);
            if (fieldOff >= this.inlineSize) {
                return false;
            }
            if (keyDef.idxType() != 19) {
                InlineIndexKeyType keyType = InlineIndexKeyTypeRegistry.get(keyDef.idxType(), keyTypeSettings);
                if (keyType.inlineSize() < 0) {
                    varLenPresents = true;
                }
                fieldOff += keyType.inlineSize(pageAddr, off + fieldOff);
                continue;
            }
            IndexKey key = r.key(i);
            if (key == NullIndexKey.INSTANCE) {
                return false;
            }
            byte type = PageUtils.getByte(pageAddr, off + fieldOff);
            if (type == 19) {
                int len = PageUtils.getShort(pageAddr, off + fieldOff + 1);
                byte[] originalObjBytes = ((JavaObjectIndexKey)key).bytesNoCopy();
                if ((len &= Short.MAX_VALUE) > this.inlineSize - fieldOff - 3 || len > originalObjBytes.length) {
                    this.inlineObjectSupportedDecision(false, "length is big " + len);
                    return true;
                }
                byte[] inlineBytes = PageUtils.getBytes(pageAddr, off + fieldOff + 3, len);
                if (!Arrays.equals(inlineBytes, originalObjBytes)) {
                    this.inlineObjectSupportedDecision(false, "byte compare");
                    return true;
                }
                this.inlineObjectSupportedDecision(true, len + " bytes compared");
                return true;
            }
            if (type == -1 && varLenPresents) {
                return false;
            }
            this.inlineObjectSupportedDecision(false, "inline type " + type);
            return true;
        }
        this.inlineObjectSupportedDecision(true, "no java objects for inlining");
        return true;
    }

    public boolean inlineObjectSupported() {
        return this.inlineObjSupported;
    }

    public static boolean objectMayBeInlined(int inlineSize, List<IndexKeyDefinition> keyDefs) {
        int remainSize = inlineSize;
        IndexKeyTypeSettings settings = new IndexKeyTypeSettings();
        for (IndexKeyDefinition def : keyDefs) {
            if (def.idxType() == 19) break;
            InlineIndexKeyType keyType = InlineIndexKeyTypeRegistry.get(def.idxType(), settings);
            if (keyType == null) {
                return false;
            }
            remainSize -= keyType.inlineSize() > 0 ? 1 + keyType.inlineSize() : 1;
        }
        return remainSize >= 4;
    }

    private void inlineObjectSupportedDecision(boolean inlineObjSupported, String reason) {
        this.inlineObjSupported = inlineObjSupported;
        if (inlineObjSupported) {
            this.log.warning("Index supports JAVA_OBJECT type inlining [tblName=" + this.idxName.tableName() + ", idxName=" + this.idxName + ", reason='" + reason + "']");
        } else {
            this.log.warning("Index doesn't support JAVA_OBJECT type inlining [tblName=" + this.idxName.tableName() + ", idxName=" + this.idxName + ", reason='" + reason + "']");
        }
    }
}

