/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.core.meter;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class RateMeterPeriod
implements Serializable {
    private final long count;
    private final long elapsedMs;

    RateMeterPeriod(long count, long elapsedMs) {
        this.count = count;
        this.elapsedMs = elapsedMs;
    }

    public long getCount() {
        return this.count;
    }

    public long getElapsedMs() {
        return this.elapsedMs;
    }

    public double getRatePer(long time, TimeUnit timeUnit) {
        if (this.elapsedMs > 0L) {
            return 1.0 * (double)timeUnit.toNanos(time) * (double)this.count / (double)this.elapsedMs / (double)TimeUnit.MILLISECONDS.toNanos(1L);
        }
        return Double.NaN;
    }

    public double getRatePerSec() {
        return this.getRatePer(1L, TimeUnit.SECONDS);
    }

    public String toString() {
        return String.format("count=%d, elapsed=%d ms, rate=%.6f evt/sec", this.getCount(), this.getElapsedMs(), this.getRatePerSec());
    }
}

