/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;

public class IpUtils {
    private static final String LOCAL_HOSTNAME;

    public static boolean isLocal(String targetServerName) {
        InetAddress address;
        if (targetServerName.equals(LOCAL_HOSTNAME)) {
            return true;
        }
        try {
            address = InetAddress.getByName(targetServerName);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return address.isLoopbackAddress() || address.isLinkLocalAddress();
    }

    public static boolean areAllLocal(Collection<String> targetServerNames) {
        for (String targetServerName : targetServerNames) {
            if (IpUtils.isLocal(targetServerName)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyLocal(Collection<String> targetServerNames) {
        for (String targetServerName : targetServerNames) {
            if (!IpUtils.isLocal(targetServerName)) continue;
            return true;
        }
        return false;
    }

    public static String getHostName() {
        return LOCAL_HOSTNAME;
    }

    public static String getHostAddress(String host) {
        try {
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            LOCAL_HOSTNAME = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

