/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.distribution;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaManagementServerInstance;
import org.terracotta.angela.common.TerracottaServerHandle;
import org.terracotta.angela.common.TerracottaVoter;
import org.terracotta.angela.common.TerracottaVoterInstance;
import org.terracotta.angela.common.ToolExecutionResult;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.License;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.topology.Topology;
import org.terracotta.angela.common.util.JavaBinaries;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;

public abstract class DistributionController {
    protected final Distribution distribution;

    DistributionController(Distribution distribution) {
        this.distribution = distribution;
    }

    public static ToolExecutionResult invokeJcmd(TerracottaServerHandle terracottaServerInstanceProcess, TerracottaCommandLineEnvironment tcEnv, String ... arguments) {
        int javaPid = terracottaServerInstanceProcess.getJavaPid();
        Path javaHome = tcEnv.getJavaHome();
        Path path = JavaBinaries.find("jcmd", javaHome).orElseThrow(() -> new IllegalStateException("jcmd not found"));
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(path.toAbsolutePath().toString());
        cmdLine.add(String.valueOf(javaPid));
        cmdLine.addAll(Arrays.asList(arguments));
        try {
            ProcessResult processResult = new ProcessExecutor((List<String>)cmdLine).redirectErrorStream(true).readOutput(true).execute();
            return new ToolExecutionResult(processResult.getExitValue(), processResult.getOutput().getLines());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract TerracottaServerHandle createTsa(TerracottaServer var1, File var2, File var3, Topology var4, Map<ServerSymbolicName, Integer> var5, TerracottaCommandLineEnvironment var6, Map<String, String> var7, List<String> var8);

    public abstract TerracottaManagementServerInstance.TerracottaManagementServerInstanceProcess startTms(File var1, File var2, TerracottaCommandLineEnvironment var3, Map<String, String> var4);

    public abstract void stopTms(File var1, TerracottaManagementServerInstance.TerracottaManagementServerInstanceProcess var2, TerracottaCommandLineEnvironment var3);

    public abstract TerracottaVoterInstance.TerracottaVoterInstanceProcess startVoter(TerracottaVoter var1, File var2, File var3, SecurityRootDirectory var4, TerracottaCommandLineEnvironment var5, Map<String, String> var6);

    public abstract void stopVoter(TerracottaVoterInstance.TerracottaVoterInstanceProcess var1);

    public abstract ToolExecutionResult invokeClusterTool(File var1, File var2, SecurityRootDirectory var3, TerracottaCommandLineEnvironment var4, Map<String, String> var5, String ... var6);

    public abstract ToolExecutionResult configureCluster(File var1, File var2, Topology var3, Map<ServerSymbolicName, Integer> var4, License var5, SecurityRootDirectory var6, TerracottaCommandLineEnvironment var7, Map<String, String> var8, String ... var9);

    public abstract ToolExecutionResult invokeConfigTool(File var1, File var2, SecurityRootDirectory var3, TerracottaCommandLineEnvironment var4, Map<String, String> var5, String ... var6);

    public abstract ToolExecutionResult activateCluster(File var1, File var2, License var3, SecurityRootDirectory var4, TerracottaCommandLineEnvironment var5, Map<String, String> var6, String ... var7);

    public abstract URI tsaUri(Collection<TerracottaServer> var1, Map<ServerSymbolicName, Integer> var2);

    public abstract String clientJarsRootFolderName(Distribution var1);

    public abstract String pluginJarsRootFolderName(Distribution var1);

    public abstract String terracottaInstallationRoot();
}

