/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.version;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.IgniteCodeGeneratingFail;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionable;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionedEntry;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerEntry;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

@IgniteCodeGeneratingFail
public class GridCacheRawVersionedEntry<K, V>
extends DataStreamerEntry
implements GridCacheVersionedEntry<K, V>,
GridCacheVersionable,
Externalizable {
    private static final long serialVersionUID = 0L;
    @GridDirectTransient
    private byte[] keyBytes;
    private byte[] valBytes;
    private long ttl;
    private long expireTime;
    private GridCacheVersion ver;

    public GridCacheRawVersionedEntry() {
    }

    public GridCacheRawVersionedEntry(KeyCacheObject key, @Nullable CacheObject val, long ttl, long expireTime, GridCacheVersion ver) {
        assert (key != null);
        this.key = key;
        this.val = val;
        this.ttl = ttl;
        this.expireTime = expireTime;
        this.ver = ver;
    }

    public GridCacheRawVersionedEntry(byte[] keyBytes, byte[] valBytes, long ttl, long expireTime, GridCacheVersion ver) {
        this.keyBytes = keyBytes;
        this.valBytes = valBytes;
        this.ttl = ttl;
        this.expireTime = expireTime;
        this.ver = ver;
    }

    @Override
    public K key() {
        assert (this.key != null) : "Entry is being improperly processed.";
        return (K)this.key.value(null, false);
    }

    public void key(KeyCacheObject key) {
        this.key = key;
    }

    public byte[] keyBytes() {
        return this.keyBytes;
    }

    @Override
    public V value(CacheObjectValueContext ctx) {
        return this.val != null ? (V)this.val.value(ctx, false) : null;
    }

    public byte[] valueBytes() {
        return this.valBytes;
    }

    @Override
    public long ttl() {
        return this.ttl;
    }

    @Override
    public long expireTime() {
        return this.expireTime;
    }

    @Override
    public byte dataCenterId() {
        return this.ver.dataCenterId();
    }

    @Override
    public int topologyVersion() {
        return this.ver.topologyVersion();
    }

    @Override
    public long order() {
        return this.ver.order();
    }

    @Override
    public GridCacheVersion version() {
        return this.ver;
    }

    public void unmarshal(CacheObjectContext ctx, Marshaller marsh) throws IgniteCheckedException {
        this.unmarshalKey(ctx, marsh);
        if (this.val == null && this.valBytes != null) {
            this.val = (CacheObject)U.unmarshal(marsh, this.valBytes, U.resolveClassLoader(ctx.kernalContext().config()));
            this.val.finishUnmarshal(ctx, null);
        }
    }

    public void unmarshal(CacheObjectContext ctx) throws IgniteCheckedException {
        assert (this.key != null);
        this.key.finishUnmarshal(ctx, null);
        if (this.val != null) {
            this.val.finishUnmarshal(ctx, null);
        }
    }

    public void unmarshalKey(CacheObjectContext ctx, Marshaller marsh) throws IgniteCheckedException {
        if (this.key == null) {
            assert (this.keyBytes != null);
            this.key = (KeyCacheObject)U.unmarshal(marsh, this.keyBytes, U.resolveClassLoader(ctx.kernalContext().config()));
            this.key.finishUnmarshal(ctx, null);
        }
    }

    public void marshal(CacheObjectContext ctx, Marshaller marsh) throws IgniteCheckedException {
        if (this.keyBytes == null) {
            this.key.prepareMarshal(ctx);
            this.keyBytes = U.marshal(marsh, (Object)this.key);
        }
        if (this.valBytes == null && this.val != null) {
            this.val.prepareMarshal(ctx);
            this.valBytes = U.marshal(marsh, (Object)this.val);
        }
    }

    public void prepareDirectMarshal(CacheObjectContext ctx) throws IgniteCheckedException {
        this.key.prepareMarshal(ctx);
        if (this.val != null) {
            this.val.prepareMarshal(ctx);
        }
    }

    @Override
    public short directType() {
        return 103;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 2: {
                this.expireTime = reader.readLong("expireTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.ttl = reader.readLong("ttl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.valBytes = reader.readByteArray("valBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.ver = (GridCacheVersion)reader.readMessage("ver");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        assert (this.key != null);
        assert (this.val == null || this.valBytes == null);
        return reader.afterMessageRead(GridCacheRawVersionedEntry.class);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        assert (this.key != null);
        assert (this.val == null || this.valBytes == null);
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 2: {
                if (!writer.writeLong("expireTime", this.expireTime)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeLong("ttl", this.ttl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeByteArray("valBytes", this.valBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeMessage("ver", this.ver)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public byte fieldsCount() {
        return 6;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        assert (false);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        assert (false);
    }

    @Override
    public String toString() {
        return S.toString(GridCacheRawVersionedEntry.class, this, "keyBytesLen", this.keyBytes != null ? Integer.valueOf(this.keyBytes.length) : "n/a", "valBytesLen", this.valBytes != null ? Integer.valueOf(this.valBytes.length) : "n/a", "super", super.toString());
    }
}

