/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.tcp;

import java.net.InetSocketAddress;
import org.netcrusher.core.buffer.BufferOptions;
import org.netcrusher.core.filter.TransformFilterFactory;
import org.netcrusher.core.reactor.NioReactor;
import org.netcrusher.core.throttle.ThrottlerFactory;
import org.netcrusher.tcp.TcpCrusherSocketOptions;
import org.netcrusher.tcp.callback.TcpClientCreation;
import org.netcrusher.tcp.callback.TcpClientDeletion;

public class TcpCrusherOptions {
    public static final int DEFAULT_BUFFER_COUNT = 64;
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    private InetSocketAddress bindAddress;
    private InetSocketAddress connectAddress;
    private InetSocketAddress bindBeforeConnectAddress;
    private NioReactor reactor;
    private TcpCrusherSocketOptions socketOptions = new TcpCrusherSocketOptions();
    private TcpClientCreation creationListener;
    private TcpClientDeletion deletionListener;
    private boolean deferredListeners;
    private TransformFilterFactory incomingTransformFilterFactory;
    private TransformFilterFactory outgoingTransformFilterFactory;
    private ThrottlerFactory incomingThrottlerFactory;
    private ThrottlerFactory outgoingThrottlerFactory;
    private BufferOptions bufferOptions = new BufferOptions();

    public TcpCrusherOptions() {
        this.bufferOptions.setCount(64);
        this.bufferOptions.setSize(32768);
        this.bufferOptions.setDirect(true);
        this.deferredListeners = true;
    }

    public void validate() {
        if (this.bindAddress == null) {
            throw new IllegalArgumentException("Bind address is not set");
        }
        if (this.connectAddress == null) {
            throw new IllegalArgumentException("Connect address is not set");
        }
        if (this.reactor == null) {
            throw new IllegalArgumentException("Reactor is not set");
        }
        if (this.socketOptions == null) {
            throw new IllegalArgumentException("Socket options are not set");
        }
        if (this.bufferOptions == null) {
            throw new IllegalArgumentException("Buffer options are not set");
        }
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public InetSocketAddress getConnectAddress() {
        return this.connectAddress;
    }

    public void setConnectAddress(InetSocketAddress connectAddress) {
        this.connectAddress = connectAddress;
    }

    public InetSocketAddress getBindBeforeConnectAddress() {
        return this.bindBeforeConnectAddress;
    }

    public void setBindBeforeConnectAddress(InetSocketAddress bindBeforeConnectAddress) {
        this.bindBeforeConnectAddress = bindBeforeConnectAddress;
    }

    public NioReactor getReactor() {
        return this.reactor;
    }

    public void setReactor(NioReactor reactor) {
        this.reactor = reactor;
    }

    public TcpCrusherSocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public void setSocketOptions(TcpCrusherSocketOptions socketOptions) {
        this.socketOptions = socketOptions;
    }

    public TcpClientCreation getCreationListener() {
        return this.creationListener;
    }

    public void setCreationListener(TcpClientCreation creationListener) {
        this.creationListener = creationListener;
    }

    public TcpClientDeletion getDeletionListener() {
        return this.deletionListener;
    }

    public void setDeletionListener(TcpClientDeletion deletionListener) {
        this.deletionListener = deletionListener;
    }

    public boolean isDeferredListeners() {
        return this.deferredListeners;
    }

    public void setDeferredListeners(boolean deferredListeners) {
        this.deferredListeners = deferredListeners;
    }

    public TransformFilterFactory getIncomingTransformFilterFactory() {
        return this.incomingTransformFilterFactory;
    }

    public void setIncomingTransformFilterFactory(TransformFilterFactory incomingTransformFilterFactory) {
        this.incomingTransformFilterFactory = incomingTransformFilterFactory;
    }

    public TransformFilterFactory getOutgoingTransformFilterFactory() {
        return this.outgoingTransformFilterFactory;
    }

    public void setOutgoingTransformFilterFactory(TransformFilterFactory outgoingTransformFilterFactory) {
        this.outgoingTransformFilterFactory = outgoingTransformFilterFactory;
    }

    public ThrottlerFactory getIncomingThrottlerFactory() {
        return this.incomingThrottlerFactory;
    }

    public void setIncomingThrottlerFactory(ThrottlerFactory incomingThrottlerFactory) {
        this.incomingThrottlerFactory = incomingThrottlerFactory;
    }

    public ThrottlerFactory getOutgoingThrottlerFactory() {
        return this.outgoingThrottlerFactory;
    }

    public void setOutgoingThrottlerFactory(ThrottlerFactory outgoingThrottlerFactory) {
        this.outgoingThrottlerFactory = outgoingThrottlerFactory;
    }

    public BufferOptions getBufferOptions() {
        return this.bufferOptions;
    }

    public void setBufferOptions(BufferOptions bufferOptions) {
        this.bufferOptions = bufferOptions;
    }
}

