/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.core.throttle;

import java.util.ArrayList;
import org.netcrusher.core.throttle.Throttler;
import org.netcrusher.core.throttle.ThrottlerFactory;

public final class Throttlers {
    private Throttlers() {
    }

    public static ThrottlerFactory sum(ThrottlerFactory ... throttlerFactories) {
        if (throttlerFactories == null || throttlerFactories.length == 0) {
            throw new IllegalArgumentException("Empty throttler array");
        }
        return clientAddress -> {
            ArrayList<Throttler> throttlers = new ArrayList<Throttler>(throttlerFactories.length);
            for (ThrottlerFactory factory : throttlerFactories) {
                throttlers.add(factory.allocate(clientAddress));
            }
            return bb -> {
                long delayNs = 0L;
                for (Throttler throttler : throttlers) {
                    delayNs += throttler.calculateDelayNs(bb);
                }
                return delayNs;
            };
        };
    }

    public static ThrottlerFactory max(ThrottlerFactory ... throttlerFactories) {
        if (throttlerFactories == null || throttlerFactories.length == 0) {
            throw new IllegalArgumentException("Empty throttler array");
        }
        return clientAddress -> {
            ArrayList<Throttler> throttlers = new ArrayList<Throttler>(throttlerFactories.length);
            for (ThrottlerFactory factory : throttlerFactories) {
                throttlers.add(factory.allocate(clientAddress));
            }
            return bb -> {
                long delayNs = Long.MIN_VALUE;
                for (Throttler throttler : throttlers) {
                    delayNs = Math.max(delayNs, throttler.calculateDelayNs(bb));
                }
                return delayNs;
            };
        };
    }

    public static ThrottlerFactory min(ThrottlerFactory ... throttlerFactories) {
        if (throttlerFactories == null || throttlerFactories.length == 0) {
            throw new IllegalArgumentException("Empty throttler array");
        }
        return clientAddress -> {
            ArrayList<Throttler> throttlers = new ArrayList<Throttler>(throttlerFactories.length);
            for (ThrottlerFactory factory : throttlerFactories) {
                throttlers.add(factory.allocate(clientAddress));
            }
            return bb -> {
                long delayNs = Long.MAX_VALUE;
                for (Throttler throttler : throttlers) {
                    delayNs = Math.min(delayNs, throttler.calculateDelayNs(bb));
                }
                return delayNs;
            };
        };
    }
}

