/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public class IgfsListingEntry
implements Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private IgniteUuid id;
    private boolean dir;

    public IgfsListingEntry() {
    }

    public IgfsListingEntry(IgfsEntryInfo fileInfo) {
        this.id = fileInfo.id();
        this.dir = fileInfo.isDirectory();
    }

    public IgfsListingEntry(IgniteUuid id, boolean dir) {
        this.id = id;
        this.dir = dir;
    }

    public IgniteUuid fileId() {
        return this.id;
    }

    public boolean isFile() {
        return !this.dir;
    }

    public boolean isDirectory() {
        return this.dir;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeGridUuid(out, this.id);
        out.writeBoolean(this.dir);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = U.readGridUuid(in);
        this.dir = in.readBoolean();
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        BinaryUtils.writeIgniteUuid(out, this.id);
        out.writeBoolean(this.dir);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.id = BinaryUtils.readIgniteUuid(in);
        this.dir = in.readBoolean();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof IgfsListingEntry && F.eq(this.id, ((IgfsListingEntry)other).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return S.toString(IgfsListingEntry.class, this);
    }
}

