/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.cluster;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteAtomicLong;

public class AtomicCounter {
    private final Ignite ignite;
    private final String name;
    private final IgniteAtomicLong igniteCounter;

    AtomicCounter(Ignite ignite, String name, long initVal) {
        this.ignite = ignite;
        this.name = name;
        this.igniteCounter = ignite.atomicLong("Atomic-Counter-" + name, initVal, true);
    }

    public long incrementAndGet() {
        return this.igniteCounter.incrementAndGet();
    }

    public long getAndIncrement() {
        return this.igniteCounter.getAndIncrement();
    }

    public long get() {
        return this.igniteCounter.get();
    }

    public long getAndSet(long value) {
        return this.igniteCounter.getAndSet(value);
    }

    public boolean compareAndSet(long expVal, long newVal) {
        return this.igniteCounter.compareAndSet(expVal, newVal);
    }

    public String toString() {
        return "" + this.get();
    }
}

