/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process;

import java.io.IOException;
import java.util.List;
import org.zeroturnaround.process.CompositeProcess;
import org.zeroturnaround.process.SystemProcess;

public class AndProcess
extends CompositeProcess {
    public AndProcess(List<? extends SystemProcess> children) {
        super(children);
    }

    @Override
    public boolean isAlive() throws IOException, InterruptedException {
        for (SystemProcess child : this.children) {
            if (!child.isAlive()) continue;
            return true;
        }
        return false;
    }

    public boolean isAllAlive() throws IOException, InterruptedException {
        for (SystemProcess child : this.children) {
            if (child.isAlive()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void waitFor() throws InterruptedException {
        for (SystemProcess child : this.children) {
            child.waitFor();
        }
    }

    @Override
    public void destroy(boolean forceful) throws IOException, InterruptedException {
        Exception firstException = null;
        for (SystemProcess child : this.children) {
            try {
                AndProcess.invokeDestroy(child, forceful);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("Failed to destroy {}", (Object)child, (Object)e);
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            try {
                throw firstException;
            }
            catch (IOException e) {
                throw e;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

