/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.tx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxRemoteAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxRemote;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteTxMappings;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.tx.TxKeyLockType;
import org.apache.ignite.internal.visor.tx.TxMappingType;
import org.apache.ignite.internal.visor.tx.TxVerboseInfo;
import org.apache.ignite.internal.visor.tx.TxVerboseKey;
import org.apache.ignite.internal.visor.tx.VisorTxInfo;
import org.apache.ignite.internal.visor.tx.VisorTxOperation;
import org.apache.ignite.internal.visor.tx.VisorTxProjection;
import org.apache.ignite.internal.visor.tx.VisorTxTaskArg;
import org.apache.ignite.internal.visor.tx.VisorTxTaskResult;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorTxTask
extends VisorMultiNodeTask<VisorTxTaskArg, Map<ClusterNode, VisorTxTaskResult>, VisorTxTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorTxTaskArg, VisorTxTaskResult> job(VisorTxTaskArg arg) {
        return new VisorTxJob(arg, this.debug);
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<VisorTxTaskArg> arg) {
        final VisorTxTaskArg taskArg = arg.getArgument();
        if (taskArg.getConsistentIds() != null) {
            return F.transform(this.ignite.cluster().forPredicate(new IgnitePredicate<ClusterNode>(){

                @Override
                public boolean apply(ClusterNode node) {
                    return taskArg.getConsistentIds().contains(node.consistentId().toString());
                }
            }).nodes(), new IgniteClosure<ClusterNode, UUID>(){

                @Override
                public UUID apply(ClusterNode node) {
                    return node.id();
                }
            });
        }
        if (taskArg.getProjection() == VisorTxProjection.SERVER) {
            return F.transform(this.ignite.cluster().forServers().nodes(), new IgniteClosure<ClusterNode, UUID>(){

                @Override
                public UUID apply(ClusterNode node) {
                    return node.id();
                }
            });
        }
        if (taskArg.getProjection() == VisorTxProjection.CLIENT) {
            return F.transform(this.ignite.cluster().forClients().nodes(), new IgniteClosure<ClusterNode, UUID>(){

                @Override
                public UUID apply(ClusterNode node) {
                    return node.id();
                }
            });
        }
        return F.transform(this.ignite.cluster().nodes(), new IgniteClosure<ClusterNode, UUID>(){

            @Override
            public UUID apply(ClusterNode node) {
                return node.id();
            }
        });
    }

    @Override
    @Nullable
    protected Map<ClusterNode, VisorTxTaskResult> reduce0(List<ComputeJobResult> results) throws IgniteException {
        TreeMap<ClusterNode, VisorTxTaskResult> mapRes = new TreeMap<ClusterNode, VisorTxTaskResult>();
        HashMap<UUID, ClusterNode> nodeMap = new HashMap<UUID, ClusterNode>();
        for (ComputeJobResult computeJobResult : results) {
            VisorTxTaskResult data = (VisorTxTaskResult)computeJobResult.getData();
            if (data == null || data.getInfos().isEmpty()) continue;
            mapRes.put(computeJobResult.getNode(), data);
            nodeMap.put(computeJobResult.getNode().id(), computeJobResult.getNode());
        }
        if (!((VisorTxTaskArg)this.taskArg).verboseMode()) {
            for (VisorTxTaskResult visorTxTaskResult : mapRes.values()) {
                List<VisorTxInfo> infos = visorTxTaskResult.getInfos();
                Iterator<VisorTxInfo> it = infos.iterator();
                while (it.hasNext()) {
                    VisorTxTaskResult res0;
                    UUID nearNodeId;
                    ClusterNode node;
                    VisorTxInfo info = it.next();
                    if (info.getXid().equals(info.getNearXid()) || (node = (ClusterNode)nodeMap.get(nearNodeId = info.getMasterNodeIds().iterator().next())) == null || (res0 = (VisorTxTaskResult)mapRes.get(node)) == null) continue;
                    boolean exists = false;
                    for (VisorTxInfo txInfo : res0.getInfos()) {
                        if (!txInfo.getXid().equals(info.getNearXid())) continue;
                        exists = true;
                        break;
                    }
                    if (!exists) continue;
                    it.remove();
                }
            }
        }
        return mapRes;
    }

    private static TxVerboseInfo createVerboseInfo(IgniteEx ignite, IgniteInternalTx locTx) {
        TxVerboseInfo res = new TxVerboseInfo();
        res.nearXidVersion(locTx.nearXidVersion());
        HashMap<Integer, String> usedCaches = new HashMap<Integer, String>();
        HashMap<Integer, String> usedCacheGroups = new HashMap<Integer, String>();
        ClusterNode locNode = ignite.context().discovery().localNode();
        res.localNodeId(locNode.id());
        res.localNodeConsistentId(locNode.consistentId());
        if (locTx instanceof GridNearTxLocal) {
            IgniteTxMappings mappings = ((GridNearTxLocal)locTx).mappings();
            ArrayList<IgniteTxEntry> nearOnlyEntries = new ArrayList<IgniteTxEntry>();
            ArrayList<IgniteTxEntry> locEntries = new ArrayList<IgniteTxEntry>();
            for (GridDistributedTxMapping mapping : mappings.mappings()) {
                if (F.eqNodes(mapping.primary(), locNode)) {
                    locEntries.addAll(mapping.entries());
                    continue;
                }
                nearOnlyEntries.addAll(mapping.entries());
            }
            res.nearNodeId(locNode.id());
            res.nearNodeConsistentId(locNode.consistentId());
            res.txMappingType(TxMappingType.NEAR);
            List<TxVerboseKey> nearOnlyTxKeys = VisorTxTask.fetchTxEntriesAndFillUsedCaches(ignite, locTx, usedCaches, usedCacheGroups, nearOnlyEntries, true);
            List<TxVerboseKey> locTxKeys = VisorTxTask.fetchTxEntriesAndFillUsedCaches(ignite, locTx, usedCaches, usedCacheGroups, locEntries, false);
            res.nearOnlyTxKeys(nearOnlyTxKeys);
            res.localTxKeys(locTxKeys);
        } else if (locTx instanceof GridDhtTxLocal) {
            UUID nearNodeId = locTx.masterNodeIds().iterator().next();
            DiscoCache discoCache = ignite.context().discovery().discoCache(locTx.topologyVersion());
            if (discoCache == null) {
                discoCache = ignite.context().discovery().discoCache();
            }
            ClusterNode nearNode = discoCache.node(nearNodeId);
            res.nearNodeId(nearNodeId);
            res.nearNodeConsistentId(nearNode.consistentId());
            res.txMappingType(TxMappingType.DHT);
            res.localTxKeys(VisorTxTask.fetchTxEntriesAndFillUsedCaches(ignite, locTx, usedCaches, usedCacheGroups, locTx.allEntries(), false));
        } else if (locTx instanceof GridDhtTxRemote) {
            Iterator<UUID> masterNodesIter = locTx.masterNodeIds().iterator();
            UUID nearNodeId = masterNodesIter.next();
            UUID dhtNodeId = masterNodesIter.next();
            DiscoCache discoCache = ignite.context().discovery().discoCache(locTx.topologyVersion());
            if (discoCache == null) {
                discoCache = ignite.context().discovery().discoCache();
            }
            ClusterNode nearNode = discoCache.node(nearNodeId);
            ClusterNode dhtNode = discoCache.node(dhtNodeId);
            res.nearNodeId(nearNodeId);
            res.nearNodeConsistentId(nearNode.consistentId());
            res.txMappingType(TxMappingType.REMOTE);
            res.dhtNodeId(dhtNodeId);
            res.dhtNodeConsistentId(dhtNode.consistentId());
            res.localTxKeys(VisorTxTask.fetchTxEntriesAndFillUsedCaches(ignite, locTx, usedCaches, usedCacheGroups, locTx.allEntries(), false));
        }
        res.usedCaches(usedCaches);
        res.usedCacheGroups(usedCacheGroups);
        return res;
    }

    private static List<TxVerboseKey> fetchTxEntriesAndFillUsedCaches(IgniteEx ignite, IgniteInternalTx locTx, Map<Integer, String> usedCaches, Map<Integer, String> usedCacheGroups, Collection<IgniteTxEntry> locEntries, boolean skipLocksCheck) {
        ArrayList<TxVerboseKey> locTxKeys = new ArrayList<TxVerboseKey>();
        for (IgniteTxEntry txEntry : locEntries) {
            GridCacheContext cacheCtx = ignite.context().cache().context().cacheContext(txEntry.cacheId());
            usedCaches.put(cacheCtx.cacheId(), cacheCtx.name());
            usedCacheGroups.put(cacheCtx.groupId(), cacheCtx.group().cacheOrGroupName());
            TxKeyLockType keyLockType = TxKeyLockType.NO_LOCK;
            GridCacheVersion ownerVer = null;
            if (!skipLocksCheck) {
                Collection<GridCacheMvccCandidate> locCandidates;
                GridCacheEntryEx entryEx = cacheCtx.cache().entryEx(txEntry.key(), locTx.topologyVersion());
                try {
                    locCandidates = entryEx.localCandidates(new GridCacheVersion[0]);
                }
                catch (GridCacheEntryRemovedException ignored) {
                    U.warn(ignite.log(), "Failed to process TX key: entry was already removed: " + txEntry.txKey());
                    continue;
                }
                boolean owner = false;
                boolean present = false;
                for (GridCacheMvccCandidate mvccCandidate : locCandidates) {
                    if (mvccCandidate.owner()) {
                        ownerVer = mvccCandidate.version();
                    }
                    if (!locTx.xidVersion().equals(mvccCandidate.version())) continue;
                    present = true;
                    if (!mvccCandidate.owner()) continue;
                    owner = true;
                }
                keyLockType = present ? (owner ? TxKeyLockType.OWNS_LOCK : TxKeyLockType.AWAITS_LOCK) : TxKeyLockType.NO_LOCK;
            }
            TxVerboseKey txVerboseKey = new TxVerboseKey(txEntry.txKey().toString(), keyLockType, ownerVer, txEntry.isRead());
            locTxKeys.add(txVerboseKey);
        }
        return locTxKeys;
    }

    private static class RemoteKillClosure
    implements TxKillClosure {
        private static final long serialVersionUID = 0L;

        private RemoteKillClosure() {
        }

        @Override
        public IgniteInternalFuture<IgniteInternalTx> apply(IgniteInternalTx tx, IgniteTxManager tm) {
            IgniteTxRemoteEx remote = (IgniteTxRemoteEx)tx;
            if (tx.isRollbackOnly() || tx.state() == TransactionState.COMMITTING || tx.state() == TransactionState.COMMITTED) {
                return new GridFinishedFuture<IgniteInternalTx>();
            }
            if (tx.state() == TransactionState.PREPARED) {
                remote.doneRemote(tx.xidVersion(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            }
            return tx.rollbackAsync();
        }
    }

    private static class LocalKillClosure
    implements TxKillClosure {
        private static final long serialVersionUID = 0L;

        private LocalKillClosure() {
        }

        @Override
        public IgniteInternalFuture<IgniteInternalTx> apply(IgniteInternalTx tx, IgniteTxManager tm) {
            return tx.isRollbackOnly() || tx.state() == TransactionState.COMMITTING || tx.state() == TransactionState.COMMITTED ? new GridFinishedFuture<IgniteInternalTx>() : ((GridDhtTxLocal)tx).rollbackDhtLocalAsync();
        }
    }

    private static class NearKillClosure
    implements TxKillClosure {
        private static final long serialVersionUID = 0L;

        private NearKillClosure() {
        }

        @Override
        public IgniteInternalFuture<IgniteInternalTx> apply(IgniteInternalTx tx, IgniteTxManager tm) {
            return tx.isRollbackOnly() || tx.state() == TransactionState.COMMITTING || tx.state() == TransactionState.COMMITTED ? new GridFinishedFuture<IgniteInternalTx>() : ((GridNearTxLocal)tx).rollbackNearTxLocalAsync(false, false);
        }
    }

    private static interface TxKillClosure
    extends IgniteBiClosure<IgniteInternalTx, IgniteTxManager, IgniteInternalFuture<IgniteInternalTx>> {
    }

    private static class TxSizeComparator
    implements Comparator<VisorTxInfo> {
        public static final TxSizeComparator INSTANCE = new TxSizeComparator();

        private TxSizeComparator() {
        }

        @Override
        public int compare(VisorTxInfo o1, VisorTxInfo o2) {
            return Long.compare(o2.getSize(), o1.getSize());
        }
    }

    private static class TxDurationComparator
    implements Comparator<VisorTxInfo> {
        public static final TxDurationComparator INSTANCE = new TxDurationComparator();

        private TxDurationComparator() {
        }

        @Override
        public int compare(VisorTxInfo o1, VisorTxInfo o2) {
            return Long.compare(o2.getDuration(), o1.getDuration());
        }
    }

    private static class TxStartTimeComparator
    implements Comparator<VisorTxInfo> {
        public static final TxStartTimeComparator INSTANCE = new TxStartTimeComparator();

        private TxStartTimeComparator() {
        }

        @Override
        public int compare(VisorTxInfo o1, VisorTxInfo o2) {
            return Long.compare(o2.getStartTime(), o1.getStartTime());
        }
    }

    private static class VisorTxJob
    extends VisorJob<VisorTxTaskArg, VisorTxTaskResult> {
        private static final long serialVersionUID = 0L;
        private static final int DEFAULT_LIMIT = 50;
        private static final TxKillClosure NEAR_KILL_CLOSURE = new NearKillClosure();
        private static final TxKillClosure LOCAL_KILL_CLOSURE = new LocalKillClosure();
        private static final TxKillClosure REMOTE_KILL_CLOSURE = new RemoteKillClosure();

        private VisorTxJob(VisorTxTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorTxTaskResult run(@Nullable VisorTxTaskArg arg) throws IgniteException {
            Boolean completed;
            if (arg == null) {
                return new VisorTxTaskResult(Collections.emptyList());
            }
            IgniteTxManager tm = this.ignite.context().cache().context().tm();
            Collection<IgniteInternalTx> transactions = tm.activeTransactions();
            ArrayList<VisorTxInfo> infos = new ArrayList<VisorTxInfo>();
            int limit = arg.getLimit() == null ? 50 : arg.getLimit();
            Pattern lbMatch = null;
            if (arg.getLabelRegex() != null) {
                try {
                    lbMatch = Pattern.compile(arg.getLabelRegex());
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
            for (IgniteInternalTx locTx : transactions) {
                IgniteTxAdapter locTx0;
                boolean skip;
                if (arg.verboseMode() && !arg.txInfoArgument().gridCacheVersion().equals(locTx.nearXidVersion()) || arg.getXid() != null && !locTx.xid().toString().equals(arg.getXid()) || arg.getState() != null && locTx.state() != arg.getState()) continue;
                long duration = U.currentTimeMillis() - locTx.startTime();
                if (arg.getMinDuration() != null && duration < arg.getMinDuration()) continue;
                String lb = null;
                int size = 0;
                ArrayList<UUID> mappings = null;
                TxKillClosure killClo = null;
                boolean bl = skip = arg.getMinSize() != null || lbMatch != null;
                if (locTx instanceof GridNearTxLocal) {
                    locTx0 = (GridNearTxLocal)locTx;
                    lb = ((GridNearTxLocal)locTx0).label();
                    if (lbMatch != null && !lbMatch.matcher(lb == null ? "null" : lb).matches()) continue;
                    mappings = new ArrayList<UUID>();
                    if (((GridNearTxLocal)locTx0).mappings() != null) {
                        IgniteTxMappings txMappings = ((GridNearTxLocal)locTx0).mappings();
                        for (GridDistributedTxMapping mapping : txMappings.single() ? Collections.singleton(txMappings.singleMapping()) : txMappings.mappings()) {
                            if (mapping == null) continue;
                            mappings.add(mapping.primary().id());
                            size += mapping.entries().size();
                        }
                    }
                    if (arg.getMinSize() != null && size < arg.getMinSize()) continue;
                    killClo = NEAR_KILL_CLOSURE;
                } else if (locTx instanceof GridDhtTxLocal) {
                    Map nearMap;
                    if (skip) continue;
                    locTx0 = (GridDhtTxLocal)locTx;
                    Map dhtMap = (Map)U.field(locTx0, "dhtMap");
                    mappings = new ArrayList();
                    if (dhtMap != null) {
                        for (GridDistributedTxMapping mapping : dhtMap.values()) {
                            mappings.add(mapping.primary().id());
                            size += mapping.entries().size();
                        }
                    }
                    if ((nearMap = (Map)U.field(locTx, "nearMap")) != null) {
                        for (GridDistributedTxMapping mapping : nearMap.values()) {
                            mappings.add(mapping.primary().id());
                            size += mapping.entries().size();
                        }
                    }
                    killClo = LOCAL_KILL_CLOSURE;
                } else if (locTx instanceof GridDhtTxRemote) {
                    if (skip) continue;
                    locTx0 = (GridDhtTxRemote)locTx;
                    size = ((GridDistributedTxRemoteAdapter)locTx0).readMap().size() + locTx.writeMap().size();
                    killClo = REMOTE_KILL_CLOSURE;
                }
                TxVerboseInfo verboseInfo = arg.verboseMode() ? VisorTxTask.createVerboseInfo(this.ignite, locTx) : null;
                infos.add(new VisorTxInfo(locTx.xid(), locTx.startTime(), duration, locTx.isolation(), locTx.concurrency(), locTx.timeout(), lb, mappings, locTx.state(), size, locTx.nearXidVersion().asGridUuid(), locTx.masterNodeIds(), locTx.topologyVersionSnapshot(), verboseInfo));
                if (arg.getOperation() == VisorTxOperation.KILL) {
                    killClo.apply(locTx, tm);
                }
                if (infos.size() != limit) continue;
                break;
            }
            if (arg.verboseMode() && infos.isEmpty() && (completed = tm.peekCompletedVersionsHistory(arg.txInfoArgument().gridCacheVersion())) != null) {
                if (Boolean.TRUE.equals(completed)) {
                    infos.add(new VisorTxInfo(arg.txInfoArgument().gridCacheVersion().asGridUuid(), TransactionState.COMMITTED));
                } else if (Boolean.FALSE.equals(completed)) {
                    infos.add(new VisorTxInfo(arg.txInfoArgument().gridCacheVersion().asGridUuid(), TransactionState.ROLLED_BACK));
                }
            }
            Comparator<VisorTxInfo> comp = TxDurationComparator.INSTANCE;
            if (arg.getSortOrder() != null) {
                switch (arg.getSortOrder()) {
                    case DURATION: {
                        comp = TxDurationComparator.INSTANCE;
                        break;
                    }
                    case SIZE: {
                        comp = TxSizeComparator.INSTANCE;
                        break;
                    }
                    case START_TIME: {
                        comp = TxStartTimeComparator.INSTANCE;
                        break;
                    }
                }
            }
            Collections.sort(infos, comp);
            return new VisorTxTaskResult(infos);
        }
    }
}

