/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.core.filter;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.netcrusher.core.filter.TransformFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFilter
implements TransformFilter {
    private static final int BYTE_RANGE = 256;
    private static final int BYTE_MASK = 255;
    private static final String[] HEX = LoggingFilter.createHexTable();
    private final InetSocketAddress clientAddress;
    private final Logger logger;
    private final Level level;

    public LoggingFilter(InetSocketAddress clientAddress, String loggerName, Level level) {
        this.logger = LoggerFactory.getLogger(loggerName);
        this.clientAddress = clientAddress;
        this.level = level;
    }

    @Override
    public void transform(ByteBuffer bb) {
        if (this.isLogEnabled()) {
            int size = bb.remaining();
            if (size > 0) {
                StringBuilder sb = new StringBuilder(size * 2);
                if (bb.hasArray()) {
                    byte[] bytes = bb.array();
                    int offset = bb.arrayOffset() + bb.position();
                    int limit = bb.arrayOffset() + bb.limit();
                    for (int i = offset; i < limit; ++i) {
                        int b = 0xFF & bytes[i];
                        sb.append(HEX[b]);
                    }
                } else {
                    for (int i = bb.position(); i < bb.limit(); ++i) {
                        int b = 0xFF & bb.get(i);
                        sb.append(HEX[b]);
                    }
                }
                this.log(this.clientAddress, size, sb);
            } else {
                this.log(this.clientAddress, size, "");
            }
        }
    }

    private boolean isLogEnabled() {
        switch (this.level) {
            case TRACE: {
                return this.logger.isTraceEnabled();
            }
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case WARN: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    private void log(InetSocketAddress clientAddress, int size, CharSequence data) {
        Object[] params = new Object[]{clientAddress, size, data};
        switch (this.level) {
            case TRACE: {
                this.logger.trace("<{}> ({}): {}", params);
                break;
            }
            case DEBUG: {
                this.logger.debug("<{}> ({}): {}", params);
                break;
            }
            case INFO: {
                this.logger.info("<{}> ({}): {}", params);
                break;
            }
            case WARN: {
                this.logger.warn("<{}> ({}): {}", params);
                break;
            }
            case ERROR: {
                this.logger.error("<{}> ({}): {}", params);
                break;
            }
        }
    }

    private static String[] createHexTable() {
        String[] hex = new String[256];
        for (int i = 0; i < 256; ++i) {
            hex[i] = String.format("%02x", i);
        }
        return hex;
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

