/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.deployment;

import java.lang.reflect.Field;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentCommunication;
import org.apache.ignite.internal.managers.deployment.GridDeploymentStore;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.deployment.DeploymentSpi;
import org.jetbrains.annotations.Nullable;

abstract class GridDeploymentStoreAdapter
implements GridDeploymentStore {
    protected final IgniteLogger log;
    protected final DeploymentSpi spi;
    protected final GridKernalContext ctx;
    protected final GridDeploymentCommunication comm;

    GridDeploymentStoreAdapter(DeploymentSpi spi, GridKernalContext ctx, GridDeploymentCommunication comm) {
        assert (spi != null);
        assert (ctx != null);
        assert (comm != null);
        this.spi = spi;
        this.ctx = ctx;
        this.comm = comm;
        this.log = ctx.log(this.getClass());
    }

    protected final String startInfo() {
        return "Deployment store started: " + this;
    }

    protected final String stopInfo() {
        return "Deployment store stopped: " + this;
    }

    @Override
    public void onKernalStart() throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Ignoring kernel started callback: " + this);
        }
    }

    @Override
    public void onKernalStop() {
    }

    @Override
    @Nullable
    public GridDeployment explicitDeploy(Class<?> cls, ClassLoader clsLdr) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Ignoring explicit deploy [cls=" + cls + ", clsLdr=" + clsLdr + ']');
        }
        return null;
    }

    protected final String userVersion(ClassLoader ldr) {
        return this.ctx.userVersion(ldr);
    }

    protected final boolean isTask(Class<?> cls) {
        return ComputeTask.class.isAssignableFrom(cls);
    }

    protected final void clearSerializationCaches() {
        block6: {
            try {
                this.clearSerializationCache(Class.forName("java.io.ObjectInputStream$Caches"), "subclassAudits");
                this.clearSerializationCache(Class.forName("java.io.ObjectOutputStream$Caches"), "subclassAudits");
                this.clearSerializationCache(Class.forName("java.io.ObjectStreamClass$Caches"), "localDescs");
                this.clearSerializationCache(Class.forName("java.io.ObjectStreamClass$Caches"), "reflectors");
            }
            catch (ClassNotFoundException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Class not found: " + e.getMessage());
                }
            }
            catch (NoSuchFieldException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Field not found: " + e.getMessage());
                }
            }
            catch (IllegalAccessException e) {
                if (!this.log.isDebugEnabled()) break block6;
                this.log.debug("Field can't be accessed: " + e.getMessage());
            }
        }
    }

    private void clearSerializationCache(Class cls, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field f = cls.getDeclaredField(fieldName);
        f.setAccessible(true);
        ((Map)f.get(null)).clear();
    }

    public String toString() {
        return S.toString(GridDeploymentStoreAdapter.class, this);
    }
}

