/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.tcp.redis;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.rest.client.message.GridClientMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisCommand;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridRedisMessage
implements GridClientMessage {
    private static final long serialVersionUID = 0L;
    private static final UUID RESP_ID = UUID.randomUUID();
    public static final byte RESP_REQ_FLAG = 42;
    private static final int CMD_POS = 0;
    private static final int KEY_POS = 1;
    private static final int AUX_OFFSET = 2;
    private final transient List<String> msgParts;
    private ByteBuffer response;
    private String cacheName;
    public static final String CACHE_NAME_PREFIX = "redis-ignite-internal-cache";
    public static final String DFLT_CACHE_NAME = "redis-ignite-internal-cache-0";

    public GridRedisMessage(int msgLen) {
        this.msgParts = new ArrayList<String>(msgLen);
        this.cacheName = DFLT_CACHE_NAME;
    }

    public void append(String part) {
        this.msgParts.add(part);
    }

    public void setResponse(ByteBuffer response) {
        this.response = response;
    }

    public ByteBuffer getResponse() {
        return this.response;
    }

    private List<String> getMsgParts() {
        return this.msgParts;
    }

    public int messageSize() {
        return this.msgParts.size();
    }

    public GridRedisCommand command() {
        return GridRedisCommand.valueOf(this.msgParts.get(0).toUpperCase());
    }

    public String key() {
        if (this.msgParts.size() <= 1) {
            return null;
        }
        return this.msgParts.get(1);
    }

    public String aux(int idx) {
        if (this.msgParts.size() <= idx) {
            return null;
        }
        return this.msgParts.get(idx);
    }

    public List<String> aux() {
        if (this.msgParts.size() <= 2) {
            return null;
        }
        return this.msgParts.subList(2, this.msgParts.size());
    }

    public List<String> auxMKeys() {
        if (this.msgParts.size() <= 1) {
            return null;
        }
        return this.msgParts.subList(1, this.msgParts.size());
    }

    public String toString() {
        return S.toString(GridRedisMessage.class, this);
    }

    @Nullable
    public String cacheName() {
        return this.cacheName;
    }

    public void cacheName(String cacheName) {
        assert (cacheName != null);
        this.cacheName = cacheName;
    }

    @Override
    public long requestId() {
        return 0L;
    }

    @Override
    public void requestId(long reqId) {
    }

    @Override
    public UUID clientId() {
        return RESP_ID;
    }

    @Override
    public void clientId(UUID id) {
        throw new IgniteException("Setting client id is not expected!");
    }

    @Override
    public UUID destinationId() {
        return null;
    }

    @Override
    public void destinationId(UUID id) {
    }

    @Override
    public byte[] sessionToken() {
        return new byte[0];
    }

    @Override
    public void sessionToken(byte[] sesTok) {
    }
}

