/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.redis;

import java.util.Collection;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.GridRedisCommandHandler;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisCommand;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisNioListener;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisProtocolParser;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridRedisConnectionCommandHandler
implements GridRedisCommandHandler {
    private static final Collection<GridRedisCommand> SUPPORTED_COMMANDS = U.sealList(GridRedisCommand.PING, GridRedisCommand.QUIT, GridRedisCommand.ECHO, GridRedisCommand.SELECT);
    private final GridKernalContext ctx;
    private static final String PONG = "PONG";

    public GridRedisConnectionCommandHandler(IgniteLogger log, GridRestProtocolHandler hnd, GridKernalContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public Collection<GridRedisCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public IgniteInternalFuture<GridRedisMessage> handleAsync(GridNioSession ses, GridRedisMessage msg) {
        assert (msg != null);
        switch (msg.command()) {
            case PING: {
                msg.setResponse(GridRedisProtocolParser.toSimpleString(PONG));
                return new GridFinishedFuture<GridRedisMessage>(msg);
            }
            case QUIT: {
                msg.setResponse(GridRedisProtocolParser.oKString());
                return new GridFinishedFuture<GridRedisMessage>(msg);
            }
            case ECHO: {
                msg.setResponse(GridRedisProtocolParser.toSimpleString(msg.key()));
                return new GridFinishedFuture<GridRedisMessage>(msg);
            }
            case SELECT: {
                String cacheIdx = msg.key();
                if (F.isEmpty(cacheIdx)) {
                    msg.setResponse(GridRedisProtocolParser.toGenericError("No cache index specified"));
                } else {
                    String cacheName = "redis-ignite-internal-cache-" + cacheIdx;
                    CacheConfiguration ccfg = this.ctx.cache().cacheConfiguration("redis-ignite-internal-cache-0");
                    ccfg.setName(cacheName);
                    this.ctx.grid().getOrCreateCache(ccfg);
                    ses.addMeta(GridRedisNioListener.CONN_CTX_META_KEY, cacheName);
                    msg.setResponse(GridRedisProtocolParser.oKString());
                }
                return new GridFinishedFuture<GridRedisMessage>(msg);
            }
        }
        return new GridFinishedFuture<GridRedisMessage>();
    }
}

