/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.continuous;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.continuous.GridContinuousMessageType;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridContinuousMessage
implements Message {
    private static final long serialVersionUID = 0L;
    private GridContinuousMessageType type;
    private UUID routineId;
    @GridToStringInclude(sensitive=true)
    @GridDirectTransient
    private Object data;
    @GridDirectCollection(value=Message.class)
    private Collection<Message> msgs;
    private byte[] dataBytes;
    private IgniteUuid futId;

    public GridContinuousMessage() {
    }

    GridContinuousMessage(GridContinuousMessageType type, @Nullable UUID routineId, @Nullable IgniteUuid futId, @Nullable Object data, boolean msgs) {
        assert (type != null);
        assert (routineId != null || type == GridContinuousMessageType.MSG_EVT_ACK);
        this.type = type;
        this.routineId = routineId;
        this.futId = futId;
        if (msgs) {
            this.msgs = (Collection)data;
        } else {
            this.data = data;
        }
    }

    public GridContinuousMessageType type() {
        return this.type;
    }

    public UUID routineId() {
        return this.routineId;
    }

    public boolean messages() {
        return this.msgs != null;
    }

    public <T> T data() {
        return (T)(this.msgs != null ? this.msgs : this.data);
    }

    public void data(Object data) {
        this.data = data;
    }

    public byte[] dataBytes() {
        return this.dataBytes;
    }

    public void dataBytes(byte[] dataBytes) {
        this.dataBytes = dataBytes;
    }

    @Override
    public void onAckReceived() {
    }

    @Nullable
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("dataBytes", this.dataBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeCollection("msgs", this.msgs, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeUuid("routineId", this.routineId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeByte("type", this.type != null ? (byte)this.type.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.dataBytes = reader.readByteArray("dataBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msgs = reader.readCollection("msgs", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.routineId = reader.readUuid("routineId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                byte typeOrd = reader.readByte("type");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.type = GridContinuousMessageType.fromOrdinal(typeOrd);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridContinuousMessage.class);
    }

    @Override
    public short directType() {
        return 61;
    }

    @Override
    public byte fieldsCount() {
        return 5;
    }

    public String toString() {
        return S.toString(GridContinuousMessage.class, this);
    }
}

